package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.articleRewardConfig.ArticleRewardConfigDto;
import cn.com.duiba.tuia.news.center.dto.newsCardRewardConfig.NewsCardRewardConfigDto;

import java.util.List;

/**
 * 功能描述：信息流卡片奖励配置接口
 *
 * @Auther: xiaotian
 * @Date: 2018/11/13 16:27
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteNewsCardRewardConfigService {

    /**
     * 查询所有的配置信息（管理端）
     * @return
     */
    List<NewsCardRewardConfigDto> selectAll();


    /**
     * 根据本版号查询（没有查到则返回大盘配置）
     * @param version
     * @return
     */
    NewsCardRewardConfigDto getConfigByVersion(String version);


    /**
     * 更新或者插入（管理端）
     * @param newsCardRewardConfigDto
     * @return
     */
    boolean insertOrUpdate(NewsCardRewardConfigDto newsCardRewardConfigDto);


}
