package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.TagLibraryDto;
import cn.com.duiba.tuia.news.center.dto.TagPublishDto;

import java.util.List;

/**
 * 子频道上架服务
 */
@AdvancedFeignClient
public interface RemoteTagPublishService {

    /**
     * 更新标签上架服务
     */
    Boolean update(TagPublishDto dto);

    /**
     * 通过标签id查询对应的上架信息
     */
    TagPublishDto findByTagId(Long tagId);

    /**
     * 更新文件排序
     * @param tagId 标签id
     * @param tagIndex 目标级别
     * @return
     */
    Boolean updateSort(Long tagId,Integer tagIndex);


    /**
     * 查询所有上架的频道
     * @return
     */
    List<TagPublishDto> findAllPublish();

    /**
     * 获取所有标签描述
     * @return
     */
    List<TagPublishDto> findAllTagDesc();


    /**
     * 查询所有一级标签
     * @return
     */
    List<TagLibraryDto> findAllLevelOneTags();
}
