package cn.com.duiba.tuia.news.center.dto;

import cn.com.duiba.tuia.news.center.enums.PartnerLevel;

import java.io.Serializable;

/**
 * 合伙人详情
 *
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PartnerDetailDto.java , v 0.1 2018-11-25 14:09 ElinZhou Exp $
 */
public class PartnerDetailDto implements Serializable {
    private static final long serialVersionUID = 1215615916319404365L;

    /**
     * 用户昵称
     */
    private String nickName;

    /**
     * 用户头像url
     */
    private String headImageUrl;
    /**
     * 会员等级
     * @see PartnerLevel
     */
    private Integer level;

    /**
     * 是否符合升级条件
     */
    private Boolean conformLevelUp;

    /**
     * 团队成员数量
     */
    private Integer members;

    /**
     * 还需邀请多少人以成为合伙人
     */
    private Integer countToLevelUp;

    /**
     * 总金币收入
     */
    private Long totalCoinIncome;

    /**
     * 预估现金收益
     */
    private Long predictChangeIncome;

    /**
     * 已结算分销收入
     */
    private Long settledSaleIncome;

    /**
     * 待结算分销收入
     */
    private Long watingSettleSaleIncome;

    /**
     * 累计进贡佣金（已结算+待结算进贡佣金总额）
     */
    private Long totalTributeChange;

    /**
     * 是否存在合伙人记录
     */
    private boolean exist;

    public boolean isExist() {
        return exist;
    }

    public void setExist(boolean exist) {
        this.exist = exist;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public Boolean getConformLevelUp() {
        return conformLevelUp;
    }

    public void setConformLevelUp(Boolean conformLevelUp) {
        this.conformLevelUp = conformLevelUp;
    }

    public Integer getMembers() {
        return members;
    }

    public void setMembers(Integer members) {
        this.members = members;
    }

    public Integer getCountToLevelUp() {
        return countToLevelUp;
    }

    public void setCountToLevelUp(Integer countToLevelUp) {
        this.countToLevelUp = countToLevelUp;
    }

    public Long getTotalCoinIncome() {
        return totalCoinIncome;
    }

    public void setTotalCoinIncome(Long totalCoinIncome) {
        this.totalCoinIncome = totalCoinIncome;
    }

    public Long getPredictChangeIncome() {
        return predictChangeIncome;
    }

    public void setPredictChangeIncome(Long predictChangeIncome) {
        this.predictChangeIncome = predictChangeIncome;
    }

    public Long getSettledSaleIncome() {
        return settledSaleIncome;
    }

    public void setSettledSaleIncome(Long settledSaleIncome) {
        this.settledSaleIncome = settledSaleIncome;
    }

    public Long getWatingSettleSaleIncome() {
        return watingSettleSaleIncome;
    }

    public void setWatingSettleSaleIncome(Long watingSettleSaleIncome) {
        this.watingSettleSaleIncome = watingSettleSaleIncome;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getHeadImageUrl() {
        return headImageUrl;
    }

    public void setHeadImageUrl(String headImageUrl) {
        this.headImageUrl = headImageUrl;
    }

    public Long getTotalTributeChange() {
        return totalTributeChange;
    }

    public void setTotalTributeChange(Long totalTributeChange) {
        this.totalTributeChange = totalTributeChange;
    }
}
