package cn.com.duiba.tuia.news.center.enums;

import cn.com.duiba.tuia.news.center.util.JiGuangPushUtils;
import com.alibaba.fastjson.JSON;

import java.util.Map;

/**
 * Created by zhou_wb on 2018/4/28.
 */
public enum AndroidPushNotificationEnum {

    TODAY_READ("TODAY_READ",JiGuangPushUtils.TODAY_READ_TITLE,JiGuangPushUtils.TODAY_READ_ALERT,JiGuangPushUtils.URL_WALLET_ACTIVITY, JiGuangPushUtils.WALLETPAGEMAP(),"/act/income_detail"),

    TODAY_SIGN("TODAY_SIGN",JiGuangPushUtils.TODAY_SIGN_TITLE,JiGuangPushUtils.TODAY_SING_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.MAINPAGEMAP(),"/main/home"),

    DIS_RED_PACKET("DIS_RED_PACKET",JiGuangPushUtils.DIS_RED_PACK_TITLE,JiGuangPushUtils.DIS_RED_PACK_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.MAINPAGEMAP(),"/main/home"),

    RECALL("RECALL",JiGuangPushUtils.RECALL_TITLE,JiGuangPushUtils.RECALL_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.MAINPAGEMAP(),"/main/home"),

    LAND_PACKET("LAND_PACKET",JiGuangPushUtils.LAND_PACKET_TITLE,JiGuangPushUtils.LAND_PACKET_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.LANDMAP(),"/web/farm"),

    LIMIT_PACKET_HELP("LIMIT_PACKET_HELP",JiGuangPushUtils.LIMIT_PACKET_HELP_TITLE,JiGuangPushUtils.LIMIT_PACKET_HELP_ALERT,JiGuangPushUtils.URL_LIMIT_PACKET_ACTIVITY,JiGuangPushUtils.LIMITPACKETMAP(),"/act/timelimit"),

    INVITE_SUCCESS("INVITE_SUCCESS",JiGuangPushUtils.INVITE_SUCCESS_TITLE,JiGuangPushUtils.INVITE_SUCCESS_ALERT,JiGuangPushUtils.URL_INVITE_ACTIVITY,JiGuangPushUtils.INVITEMAP(),"/mine/invite"),

    PACKET_DOUBLE("PACKET_DOUBLE",JiGuangPushUtils.DOUBLE_PACKET_TITLE,JiGuangPushUtils.DOUBLE_PACKET_ALERT,JiGuangPushUtils.URL_INVITE_ACTIVITY,JiGuangPushUtils.INVITEMAP(),"/mine/invite"),

    LUCK_PACKET_IN("LUCK_PACKET_IN",JiGuangPushUtils.LUCK_PACKET_SEND_IN_TITLE,JiGuangPushUtils.LUCK_PACKET_SEND_IN_ALERT,JiGuangPushUtils.URL_LUCK_PACKET_ACTIVITY,JiGuangPushUtils.LUCKPACKETMAP(),"/web/commweb"),

    LUCK_PACKET_WAIT("LUCK_PACKET_WAIT",JiGuangPushUtils.LUCK_PACKET_SEND_WAIT_TITLE,JiGuangPushUtils.LUCK_PACKET_SEND_WAIT_ALERT,JiGuangPushUtils.URL_LUCK_PACKET_ACTIVITY,JiGuangPushUtils.LUCKPACKETMAP(),"/web/commweb"),

    /**
     * 1.红包熟了推送：新用户农场未领取也算有； 文案1
     */
    WAKE_TO_PICK_1("WAKE_TO_PICK_1",JiGuangPushUtils.WAKE_TO_PICK_1_TITLE,JiGuangPushUtils.WAKE_TO_PICK_1_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.REDPACKETFARMMAP(),"/main/home"),

    /**
     *  1.红包熟了推送：新用户农场未领取也算有； 文案2
     */
    WAKE_TO_PICK_2("WAKE_TO_PICK_2",JiGuangPushUtils.WAKE_TO_PICK_2_TITLE,JiGuangPushUtils.WAKE_TO_PICK_2_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.REDPACKETFARMMAP(),"/main/home"),

    /**
     * 点点赚推送
     */
    POINT_PACKET("POINT_PACKET",JiGuangPushUtils.POINT_PACKET_TITLE,JiGuangPushUtils.POINT_PACKET_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.POINTPACKETINTRMAP(),"/main/home"),

    /**
     * 活动金币收益
     */
    ACTIVITY_SET_COIN_REWARD("ACTIVITY_SET_COIN_REWARD",JiGuangPushUtils.ACTIVITY_REWARD_TITLE,JiGuangPushUtils.ACTIVITY_REWARD_ALERT,JiGuangPushUtils.URL_LUCK_PACKET_ACTIVITY,JiGuangPushUtils.ACTIVITYCOINREWARD(),"/web/commweb"),

    /**
     * 活动合集
     */
    ACTIVITY_SET("ACTIVITY_SET",JiGuangPushUtils.ACTIVITY_SET_TITLE,JiGuangPushUtils.ACTIVITY_SET_ALERT,JiGuangPushUtils.URL_LUCK_PACKET_ACTIVITY,JiGuangPushUtils.ACTIVITYCOINREWARD(),"/web/commweb"),
    /**
     * 一元提现提醒
     */
    ONE_CASH_WITHDRAW_REMIND("ONE_CASH_WITHDRAW_REMIND",JiGuangPushUtils.ONE_CASH_WITHDRAW_TITLE,JiGuangPushUtils.ONE_CASH_WITHDRAW_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.ONECASHWITHDRAW(),"/main/home"),

    /**
     * 时时乐开奖
     */
    LOTTERY_OPEN("LOTTERY_OPEN",JiGuangPushUtils.ONE_CASH_WITHDRAW_TITLE,JiGuangPushUtils.ONE_CASH_WITHDRAW_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.ONECASHWITHDRAW(),"/main/home"),
    ;

    private String type;

    private String title;

    private String alert;

    private String activityUrl;

    private Map<String,String>  extra;

    private String jumpCode;

    AndroidPushNotificationEnum(String type, String title, String alert, String activityUrl, Map<String, String> extra, String jumpCode) {
        this.type = type;
        this.title = title;
        this.alert = alert;
        this.activityUrl = activityUrl;
        this.extra = extra;
        this.jumpCode = jumpCode;
    }

    public String getActivityUrl() {
        return activityUrl;
    }

    public String getType() {
        return type;
    }

    public String getTitle() {
        return title;
    }

    public String getAlert() {
        return alert;
    }

    public Map<String, String> getExtra() {
        return extra;
    }

    public String getJumpCode() {
        return jumpCode;
    }

    public static AndroidPushNotificationEnum getByType(String type){
        for (AndroidPushNotificationEnum androidPushNotificationEnum :values()
             ) {
            if (androidPushNotificationEnum.type.equals(type)){
                return androidPushNotificationEnum;
            }
        }
        return null;
    }
    public static Map<String,String> getTransmissionContent(AndroidPushNotificationEnum androidPushNotificationEnum){
        Map<String,String> extra = androidPushNotificationEnum.getExtra();
        extra.put("path",androidPushNotificationEnum.jumpCode);
        return extra;
    }
}
