package cn.com.duiba.tuia.news.center.enums;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @author ElinZhou
 * @version $Id: AppType.java , v 0.1 2018/1/4 下午8:00 ElinZhou Exp $
 */
public enum SimplePlayType {

    READ(1),

    HIKE(2),

    FORM(3);

    private Integer code;

    SimplePlayType(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    public static SimplePlayType getByCode(Integer type){
        return Stream.of(SimplePlayType.values()).filter(simplePlayType -> Objects.equals(simplePlayType.getCode(), type)).findFirst().orElse(READ);
    }
}
