package cn.com.duiba.tuia.news.center.enums.treeRewardConfig;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 审核状态
 *
 * @author ElinZhou
 * @version $Id: ApplyStatus.java , v 0.1 2018/1/2 下午3:50 ElinZhou Exp $
 */
public enum TreeRewardConfigEnum {
    /**
     * 点开激励视频
     */
    VIDOE_DIAN(0,"点开激励视频"),

    /**
     * 汇量激励视频
     */
    VIDEO_HUI(1,"汇量激励视频"),

    /**
     * 穿山甲激励视频
     */
    VIDEO_PANGOLIN(2,"穿山甲激励视频"),

    /**
     * 激励互动
     */
    TUIA_H5(3,"激励互动"),

    /**
     * 原生sdk
     */
    YUAN_SDK(4,"原生sdk"),

    /**
     * 直投广告（金币）
     */
    HU_COIN(5,"直投广告（金币）"),

    /**
     * 直投广告（非金币）
     */
    HU_NO_COIN(6,"直投广告（非金币）"),

    /**
     * 视频H5
     */
    BOX_COIN(7,"宝箱金币"),

    ;
    private static final Map<Integer, TreeRewardConfigEnum> CACHE = Maps.uniqueIndex(Arrays.asList(TreeRewardConfigEnum
            .values()), TreeRewardConfigEnum::getCode);

    private Integer code;
    private String desc;

    TreeRewardConfigEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);
    }

    public static TreeRewardConfigEnum of(Integer aCode) {
        return CACHE.get(aCode);
    }

}
