package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.StepDetailDto;
import cn.com.duiba.tuia.news.center.dto.StepReportVo;
import cn.com.duiba.tuia.news.center.dto.req.ActivityWindowsReqDto;
import cn.com.duiba.tuia.news.center.dto.req.BaseQueryDto;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;
import cn.com.duiba.tuia.news.center.dto.req.StepReportReqDto;
import cn.com.duiba.tuia.news.center.dto.req.StepReportUpdateDto;
import cn.com.duiba.tuia.news.center.dto.req.StepRewardReqDto;
import cn.com.duiba.tuia.news.center.dto.rsp.StepRewardRspDto;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteStepService.java , v 0.1 2019-02-25 14:23 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteStepService {


    /**
     * 领取步数奖励
     *
     * @param reqDto
     * @return
     */
    StepRewardRspDto stepReward(StepRewardReqDto reqDto) throws BizException;


    /**
     * 计步详情
     *
     * @param userId
     * @return
     */
    StepDetailDto detail(Long userId);


    /**
     * 是否展示计步入口
     *
     * @param reqDto
     * @return
     */
    boolean showStepEntrance(ActivityWindowsReqDto reqDto);


    /**
     * 计步上报
     *
     * @param reportReqDto
     */
    void report(StepReportReqDto reportReqDto);

    /**
     * 查询上报列表
     *
     * @param baseQueryDto
     * @return
     */
    PageQueryResultDto<StepReportVo> list(BaseQueryDto baseQueryDto);

    /**
     * 更新上报状态
     *
     * @param updateDto
     * @return
     */
    boolean update(StepReportUpdateDto updateDto);



}
