package cn.com.duiba.tuia.news.center.util;

import cn.com.duiba.tuia.news.center.enums.RedisKey;
import com.google.common.base.Joiner;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * redis key组装工具类
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RedisKeyUtil.java , v 0.1 2017/5/19 下午4:56 ZhouFeng Exp $
 */
public class RedisKeyUtil {

    private static final String SEPARATOR = "_";

    private static final String NC_PREFIX = "NC";

    private static final String TUIA_PREFIX = "TUIA";

    /**
     * token对应userid缓存key
     *
     * @param token
     * @return
     */
    public static String tokenKey(String token) {
        return getKey(RedisKey.K49, token);
    }

    /**
     * 目标不可重复性任务日完成记录key
     *
     * @param userId
     * @param taskId
     * @param localDate
     * @return
     */
    public static String uniqueRewardTaskKey(Long userId, Long taskId, LocalDate localDate) {
        return getKey(RedisKey.K50, userId, taskId, localDate);
    }

    /**
     * 用户领奖分布式锁key
     *
     * @param userId
     * @param taskId
     * @return
     */
    public static String rewardTaskLockKey(Long userId, Long taskId) {
        return getKey(RedisKey.K51, userId, taskId);
    }

    /**
     * 未结算金币key
     *
     * @param userId
     * @return
     */
    public static String unsettleCoinsKey(Long userId) {
        return getKey(RedisKey.K52, userId);
    }

    /**
     * 昨日收入key
     *
     * @param userId
     * @return
     */
    public static String yesterdayIncomeKey(Long userId) {
        return getKey(RedisKey.K53, userId);
    }

    /**
     * 用户已结算零钱总额缓存
     *
     * @param userId
     * @return
     */
    public static String settledChangeKey(Long userId) {
        return getKey(RedisKey.K54, userId);
    }
    /**
     * 用户今日已经看过的文章加视频数量
     *
     * @param userId
     * @return
     */
    public static String allReadTaskNumKey(Long userId) {
        return getKey(RedisKey.K68, userId);
    }

    /**
     *  版本控制的Key
     *
     * @return
     */
    public static String versionKey() {
        return getKey(RedisKey.K69);
    }

    /**
     * 设置第七天中奖的该路和人数的Key
     *
     * @return
     */
    public static String probabilityAndPerNumKey() {
        return getKey(RedisKey.K70);
    }

    /**
     * 金额大额中奖人数
     *
     * @return
     */
    public static String PerNumKey() {
        return getKey(RedisKey.K71);
    }

    /**
     * 今日用户获取的金币数量key
     *
     * @param userId    用户id
     * @param taskId    任务 id
     * @param localDate 日期
     */
    public static String todayTaskCoinKey(Long userId, Long taskId, LocalDate localDate) {
        return getKey(RedisKey.K63, userId, taskId, localDate);
    }

    private static String getKey(RedisKey redisKey, Object... objects) {
        return getKey(NC_PREFIX, redisKey, objects);
    }

    private static String getKey(String prefix, RedisKey redisKey, Object... objects) {


        Joiner joiner = Joiner.on(SEPARATOR).skipNulls();
        List<Object> items = new ArrayList<>();
        items.add(prefix);
        items.add(redisKey);
        items.addAll(Arrays.stream(objects).map(value -> value == null ? "null" : value).collect(Collectors.toList()));
        return joiner.join(items);

    }

    private RedisKeyUtil() {
        // 不允许创建实例
    }

   
}
