package cn.com.duiba.tuia.news.center.util;

import cn.com.duiba.tuia.news.center.enums.RedisKey;
import com.google.common.base.Joiner;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * redis key组装工具类
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RedisKeyUtil.java , v 0.1 2017/5/19 下午4:56 ZhouFeng Exp $
 */
public class RedisKeyUtil {

    private static final String SEPARATOR = "_";

    private static final String NC_PREFIX = "NC";

    private static final String TUIA_PREFIX = "TUIA";

    /**
     * token对应userid缓存key
     *
     * @param token
     * @return
     */
    public static String tokenKey(String token) {
        return getKey(RedisKey.K49, token);
    }

    /**
     * 目标不可重复性任务日完成记录key
     *
     * @param userId
     * @param taskId
     * @param localDate
     * @return
     */
    public static String uniqueRewardTaskKey(Long userId, Long taskId, LocalDate localDate) {
        return getKey(RedisKey.K50, userId, taskId, localDate);
    }

    /**
     * 用户领奖分布式锁key
     *
     * @param userId
     * @param taskId
     * @return
     */
    public static String rewardTaskLockKey(Long userId, Long taskId) {
        return getKey(RedisKey.K51, userId, taskId);
    }

    /**
     * 未结算金币key
     *
     * @param userId
     * @return
     */
    public static String unsettleCoinsKey(Long userId) {
        return getKey(RedisKey.K52, userId);
    }

    /**
     * 昨日收入key
     *
     * @param userId
     * @return
     */
    public static String yesterdayIncomeKey(Long userId) {
        return getKey(RedisKey.K53, userId);
    }

    /**
     * 用户已结算零钱总额缓存
     *
     * @param userId
     * @return
     */
    public static String settledChangeKey(Long userId) {
        return getKey(RedisKey.K54, userId);
    }

    /**
     * 用户今日已经看过的文章加视频数量(新)
     *
     * @param userId
     * @return
     */
    public static String allReadTaskNumKeyNew(Long userId, LocalDate localDate) {
        return getKey(RedisKey.K68, userId,localDate);
    }

    /**
     * 获取用户提现锁（防刷）
     *
     * @param userId
     * @return
     */
    public static String withdrawKey(Long userId,Integer source,Long fee) {
        return getKey(RedisKey.K72, userId,source,fee);
    }

    /**
     *  版本控制的Key
     *
     * @return
     */
    public static String versionKey() {
        return getKey(RedisKey.K69);
    }

    /**
     * 设置第七天中奖的该路和人数的Key
     *
     * @return
     */
    public static String probabilityAndPerNumKey() {
        return getKey(RedisKey.K70);
    }

    /**
     * 金额大额中奖人数
     *
     * @return
     */
    public static String PerNumKey() {
        return getKey(RedisKey.K71);
    }

    /**
     * 10分钟短信验证码
     *
     * @return
     */
    public static String verificationCodeKey(String phoneNum) {
        return getKey(RedisKey.K75,phoneNum);
    }
    /**
     * 一天内无法发送的短信数量
     *
     * @return
     */
    public static String sendMesCountKey(String deviceId,LocalDate localDate) {
        return getKey(RedisKey.K76,deviceId,localDate);
    }


    /**
     * 微信好友的帮戳记录
     *
     * @return
     */
    public static String helpList(String unionId,LocalDate localDate) {
        return getKey(RedisKey.K88,unionId,localDate);
    }


    /**
     * 微信好友的帮戳锁
     *
     * @return
     */
    public static String helpLock(Long packetId) {
        return getKey(RedisKey.K89,packetId);
    }


    /**
     *  限时红包提现锁
     *
     * @return
     */
    public static String limitWithdraw(Long userId) {
        return getKey(RedisKey.K90,userId);
    }

    /**
     * 一个手机号在55秒内不能重新发送短信
     * @param phonenum
     * @return
     */
    public static String sendMesRepetitionKey(String phonenum) {
        return getKey(RedisKey.K78,phonenum);
    }

    /**
     * 手机好登陆防止不能多次登陆
     * @param phonenum
     * @return
     */
    public static  String phoneLoginKey(String phonenum){
        return getKey(RedisKey.K80,phonenum);
    }

    /**
     * 发送短信验证码的key（redis锁防止重复发送短信验证码）
     * @param phoneNum
     * @return
     */
    public static  String sendMesKey(String phoneNum){
        return getKey(RedisKey.K79,phoneNum);
    }


    /**
     * 用户第一块地的开启时间
     * @param userId
     * @return
     */
    public static  String getFristLandCreate(Long userId){
        return getKey(RedisKey.K81,userId);
    }

    /**
     * 今日用户获取的金币数量key
     *
     * @param userId    用户id
     * @param taskId    任务 id
     * @param localDate 日期
     */
    public static String todayTaskCoinKey(Long userId, Long taskId, LocalDate localDate) {
        return getKey(RedisKey.K63, userId, taskId, localDate);
    }

    /**
     * 被邀请人阅读文章邀请人结算现金金币key
     * @param userId
     * @param type
     * @return
     */
    public static  String inviteeReadingRewardKey(Long userId,Integer type){
        return getKey(RedisKey.K82, userId, type);
    }


    /**
     * 开土地的自旋锁Key
     * @param userId
     * @param taskId
     * @return
     */
    public static  String openLandKey(Long userId,Integer taskId){
        return getKey(RedisKey.K84, userId, taskId);
    }

    /**
     *  摘红包的自旋锁Key
     * @param userId
     * @param landId
     * @return
     */
    public static  String pickPacketKey(Long userId,Long landId){
        return getKey(RedisKey.K85, userId, landId);
    }

    /**
     * 邀请人获取被邀请人的奖励金锁key
     * @param userId
     * @return
     */
    public static  String getInviteChangeRewardKey(Long userId){
        return getKey(RedisKey.K86, userId);
    }


    /**
     * 获取微信的的accessToken
     * @param code
     * @return
     */
    public static  String wechatAccessToken(String code){
        return getKey(RedisKey.K93, code);
    }
    /**
     * 好友阅读结算限流key
     * @return
     */
    public static  String getInviteRewardLimitKey(){
        return getKey(RedisKey.K87);
    }


    /**
     * 待推送消息key
     *
     * @param time
     * @return
     */
    public static String getWaitPushKey(LocalDateTime time) {
        return getKey(RedisKey.K91, time.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
    }

    /**
     * 待推送锁key
     *
     * @return
     */
    public static String getWaitPushLockKey() {
        return getKey(RedisKey.K91);
    }


    /**
     * 用户开启定时红包的key
     *
     * @return
     */
    public static String openLimitPacketKey(Long userId) {
        return getKey(RedisKey.K95,userId);
    }


    /**
     * 微信临时token
     *
     * @return
     */
    public static String wechatToken() {
        return getKey(RedisKey.K96);
    }


    /**
     * 微信临时ticket
     *
     * @return
     */
    public static String wechatTicket() {
        return getKey(RedisKey.K97);
    }

    /**
     * 新人帮戳redis锁
     *
     * @return
     */
    public static String newsHelpKey(Long packetId) {
        return getKey(RedisKey.K98,packetId);
    }

    /**
     * 微信用户信息
     * @return
     */
    public static String wechatUserInfo(String openId) {
        return getKey(RedisKey.K99,openId);
    }


    /**
     * 用户分享邀请链接发放奖励锁
     * @return
     */
    public static String shareInviteKey(Long userId) {
        return getKey(RedisKey.K100,userId);
    }

    /**
     * 最后一次刷新农场的时间
     * @param userId
     * @return
     */
    public static String lastRefreshFarm(Long userId){
        return getKey(RedisKey.K103,userId);
    }

    /**
     * 今日是否刷新过陌生人列表
     * @param userId
     * @return
     */
    public static String todayReflashStranger(Long userId,LocalDate date){
        return getKey(RedisKey.K106,userId,date);
    }

    /**
     * 当前的陌生人列表
     * @param userId
     * @return
     */
    public static String strangerList(Long userId){
        return getKey(RedisKey.K107,userId);
    }


    /**
     * 当前的陌生人列表
     * @return
     */
    public static String canPickUserIdSet(){
        return getKey(RedisKey.K108);
    }

    /**
     * 正在对谁家的土地做操作
     * @return
     */
    public static String operateUserIdFarm(Long userId){
        return getKey(RedisKey.K108,userId);
    }

    /**
     * 新红包农场用户第一块地的开启时间
     * @param userId
     * @return
     */
    public static  String getNewFristLandCreate(Long userId){
        return getKey(RedisKey.K110,userId);
    }

    /**
     * 获取农场用户操作当前时间的key 精确到秒
     * @param time
     * @return
     */
    public static String getLandUsersOpt(String time){return getKey(RedisKey.K111,time);}

    /**
     * 是否好友列表迁移过邀请列表
     * @param userId
     * @return
     */
    public static  String moveInviteToFriend(Long userId){
        return getKey(RedisKey.K112,userId);
    }

    /**
     * 今日是否获取过邀请奖励金
     * @param userId
     * @return
     */
    public static  String alreadyGetInviteChange(Long userId,LocalDate localDate){
        return getKey(RedisKey.K113,userId,localDate);
    }

    /**
     * 判断今日给狗咬的次数
     * @param userId
     * @return
     */
    public static  String getDogDefeanse(Long userId,Long dogUserId,LocalDate localDate){
        return getKey(RedisKey.K114,userId,dogUserId,localDate);
    }
    /**
     * 获取用户绑定小蜜的key

     * @return
     */
    public static String  pickAssistantLastTime(Long userId){
        return getKey(RedisKey.K115,userId);
    }


    /**
     * 用户获取打狗棒的新闻Id的储存
     * @return
     */
    public static String  getDogProp(Long userId,Integer taskId,LocalDate date){
        return getKey(RedisKey.K116,userId,taskId,date);
    }




    /**
     * 用户获取打狗棒的新闻Id的储存
     * @return
     */
    public static String  getFriendAndSecondPacketIds(Long userId){
        return getKey(RedisKey.K117,userId);
    }

    /**
     * 添加好友申请
     * @return
     */
    public static String  applyFriendKey(Long userId){
        return getKey(RedisKey.K118,userId);
    }


    /**
     * 处理好友申请
     * @return
     */
    public static String  operateFriendApply(Long userId){
        return getKey(RedisKey.K119,userId);
    }




    private static String getKey(RedisKey redisKey, Object... objects) {
        return getKey(NC_PREFIX, redisKey, objects);
    }

    private static String getKey(String prefix, RedisKey redisKey, Object... objects) {


        Joiner joiner = Joiner.on(SEPARATOR).skipNulls();
        List<Object> items = new ArrayList<>();
        items.add(prefix);
        items.add(redisKey);
        items.addAll(Arrays.stream(objects).map(value -> value == null ? "null" : value).collect(Collectors.toList()));
        return joiner.join(items);

    }

    private RedisKeyUtil() {
        // 不允许创建实例
    }

   
}
