/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class VersionUtil {
    public static final Long FIRST = 0L;
    public static final Long LAST = 0xFFFFFFFFFFL;

    private VersionUtil() {
        throw new UnsupportedOperationException("\u6d93\u5d85\u5f72\u7039\u70b0\u7de5\u9356\u682b\u6b91\u7eeb\ufffd");
    }

    public static Long toVersionNumber(String code) {
        if (StringUtils.isBlank((String)code)) {
            throw new IllegalArgumentException("\u9417\u581f\u6e70\u9359\u8702\u8d1f\u7ecc\ufffd");
        }
        AtomicInteger bit = new AtomicInteger(32);
        return Splitter.on((String)".").omitEmptyStrings().trimResults().splitToList((CharSequence)code).stream().mapToLong(Long::parseLong).reduce(0L, (a, b) -> a | b << bit.getAndAdd(-8));
    }

    public static String toVersionCode(Long num) {
        if (num == null) {
            throw new IllegalArgumentException("\u9417\u581f\u6e70\u9359\u8702\u7b09\u9473\u6212\u8d1f\u7ecc\ufffd");
        }
        return Joiner.on((String)".").join((Iterable)Stream.iterate(40, bit -> {
            bit = bit - 8;
            return bit;
        }).limit(5L).map(bit -> ((long)Math.pow(2.0, bit.intValue()) - 1L & num) >> bit - 8).map(String::valueOf).collect(Collectors.toList()));
    }

    public static void main(String ... args) {
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("1.2.3.4.5")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("0.2.3.4.5")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("100.2.3.4.5")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("1")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("1.2")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("1.2.3")));
        System.out.println(VersionUtil.toVersionCode(VersionUtil.toVersionNumber("0")));
        System.out.println(VersionUtil.toVersionNumber("1.4.5"));
    }
}

