package cn.com.duiba.tuia.news.center.util;

import cn.com.duiba.tuia.news.center.enums.RedisKey;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Joiner;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * redis key组装工具类
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RedisKeyUtil.java , v 0.1 2017/5/19 下午4:56 ZhouFeng Exp $
 */
public class RedisKeyUtil {

    private static final String SEPARATOR = "_";

    private static final String NC_PREFIX = "NC";

    private static final String TUIA_PREFIX = "TUIA";

    /**
     * token对应userid缓存key
     *
     * @param token
     * @return
     */
    public static String tokenKey(String token) {
        return getKey(RedisKey.K49, token);
    }

    /**
     * 目标不可重复性任务日完成记录key
     *
     * @param userId
     * @param taskId
     * @param localDate
     * @return
     */
    public static String uniqueRewardTaskKey(Long userId, Long taskId, LocalDate localDate) {
        return getKey(RedisKey.K50, userId, taskId, localDate);
    }

    /**
     * 用户领奖分布式锁key
     *
     * @param userId
     * @param taskId
     * @return
     */
    public static String rewardTaskLockKey(Long userId, Long taskId) {
        return getKey(RedisKey.K051, userId, taskId);
    }

    /**
     * 未结算金币key
     *
     * @param userId
     * @return
     */
    public static String unsettleCoinsKey(Long userId) {
        return getKey(RedisKey.K52, userId);
    }

    /**
     * 昨日收入key
     *
     * @param userId
     * @return
     */
    public static String yesterdayIncomeKey(Long userId) {
        return getKey(RedisKey.K53, userId);
    }

    /**
     * 用户已结算零钱总额缓存
     *
     * @param userId
     * @return
     */
    public static String settledChangeKey(Long userId) {
        return getKey(RedisKey.K54, userId);
    }

    /**
     * 用户今日已经看过的文章加视频数量(新)
     *
     * @param userId
     * @return
     */
    public static String allReadTaskNumKeyNew(Long userId, LocalDate localDate) {
        return getKey(RedisKey.K68, userId,localDate);
    }

    /**
     * 获取用户提现锁（防刷）
     *
     * @param userId
     * @return
     */
    public static String withdrawKey(Long userId,Integer source,Long fee) {
        return getKey(RedisKey.K072, userId,source,fee);
    }

    /**
     *  版本控制的Key
     *
     * @return
     */
    public static String versionKey() {
        return getKey(RedisKey.K69);
    }

    /**
     * 设置第七天中奖的该路和人数的Key
     *
     * @return
     */
    public static String probabilityAndPerNumKey() {
        return getKey(RedisKey.K70);
    }

    /**
     * 金额大额中奖人数
     *
     * @return
     */
    public static String PerNumKey() {
        return getKey(RedisKey.K71);
    }

    /**
     * 10分钟短信验证码
     *
     * @return
     */
    public static String verificationCodeKey(String phoneNum) {
        return getKey(RedisKey.K75,phoneNum);
    }
    /**
     * 一天内无法发送的短信数量
     *
     * @return
     */
    public static String sendMesCountKey(String deviceId,LocalDate localDate) {
        return getKey(RedisKey.K76,deviceId,localDate);
    }


    /**
     * 微信好友的帮戳记录
     *
     * @return
     */
    public static String helpList(String unionId,LocalDate localDate) {
        return getKey(RedisKey.K88,unionId,localDate);
    }


    /**
     * 微信好友的帮戳锁
     *
     * @return
     */
    public static String helpLock(Long packetId) {
        return getKey(RedisKey.K089,packetId);
    }


    /**
     *  限时红包提现锁
     *
     * @return
     */
    public static String limitWithdraw(Long userId) {
        return getKey(RedisKey.K090,userId);
    }

    /**
     * 一个手机号在55秒内不能重新发送短信
     * @param phonenum
     * @return
     */
    public static String sendMesRepetitionKey(String phonenum) {
        return getKey(RedisKey.K78,phonenum);
    }

    /**
     * 手机好登陆防止不能多次登陆
     * @param phonenum
     * @return
     */
    public static  String phoneLoginKey(String phonenum){
        return getKey(RedisKey.K80,phonenum);
    }

    /**
     * 发送短信验证码的key（redis锁防止重复发送短信验证码）
     * @param phoneNum
     * @return
     */
    public static  String sendMesKey(String phoneNum){
        return getKey(RedisKey.K79,phoneNum);
    }


    /**
     * 用户第一块地的开启时间
     * @param userId
     * @return
     */
    public static  String getFristLandCreate(Long userId){
        return getKey(RedisKey.K81,userId);
    }

    /**
     * 今日用户获取的金币数量key
     *
     * @param userId    用户id
     * @param taskId    任务 id
     * @param localDate 日期
     */
    public static String todayTaskCoinKey(Long userId, Long taskId, LocalDate localDate) {
        return getKey(RedisKey.K63, userId, taskId, localDate);
    }

    /**
     * 被邀请人阅读文章邀请人结算现金金币key
     * @param userId
     * @param type
     * @return
     */
    public static  String inviteeReadingRewardKey(Long userId,Integer type){
        return getKey(RedisKey.K082, userId, type);
    }


    /**
     * 开土地的自旋锁Key
     * @param userId
     * @param taskId
     * @return
     */
    public static  String openLandKey(Long userId,Integer taskId){
        return getKey(RedisKey.K084, userId, taskId);
    }

    /**
     *  摘红包的自旋锁Key
     * @param userId
     * @param landId
     * @return
     */
    public static  String pickPacketKey(Long userId,Long landId){
        return getKey(RedisKey.K85, userId, landId);
    }

    /**
     * 邀请人获取被邀请人的奖励金锁key
     * @param userId
     * @return
     */
    public static  String getInviteChangeRewardKey(Long userId){
        return getKey(RedisKey.K86, userId);
    }


    /**
     * 获取微信的的accessToken
     * @param code
     * @return
     */
    public static  String wechatAccessToken(String code){
        return getKey(RedisKey.K93, code);
    }
    /**
     * 好友阅读结算限流key
     * @return
     */
    public static  String getInviteRewardLimitKey(){
        return getKey(RedisKey.K87);
    }


    /**
     * 待推送消息key
     *
     * @param time
     * @return
     */
    public static String getWaitPushKey(LocalDateTime time) {
        return getKey(RedisKey.K91, time.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
    }

    /**
     * 待推送锁key
     *
     * @return
     */
    public static String getWaitPushLockKey() {
        return getKey(RedisKey.K91);
    }


    /**
     * 用户开启定时红包的key
     *
     * @return
     */
    public static String openLimitPacketKey(Long userId) {
        return getKey(RedisKey.K095,userId);
    }


    /**
     * 微信临时token
     *
     * @return
     */
    public static String wechatToken() {
        return getKey(RedisKey.K96);
    }


    /**
     * 微信临时ticket
     *
     * @return
     */
    public static String wechatTicket() {
        return getKey(RedisKey.K97);
    }

    /**
     * 新人帮戳redis锁
     *
     * @return
     */
    public static String newsHelpKey(Long packetId) {
        return getKey(RedisKey.K098,packetId);
    }

    /**
     * 微信用户信息
     * @return
     */
    public static String wechatUserInfo(String openId) {
        return getKey(RedisKey.K99,openId);
    }


    /**
     * 用户分享邀请链接发放奖励锁
     * @return
     */
    public static String shareInviteKey(Long userId) {
        return getKey(RedisKey.K0100,userId);
    }

    /**
     * 最后一次刷新农场的时间
     * @param userId
     * @return
     */
    public static String lastRefreshFarm(Long userId){
        return getKey(RedisKey.K103,userId);
    }

    /**
     * 今日是否刷新过陌生人列表
     * @param userId
     * @return
     */
    public static String todayReflashStranger(Long userId,LocalDate date){
        return getKey(RedisKey.K106,userId,date);
    }

    /**
     * 当前的陌生人列表
     * @param userId
     * @return
     */
    public static String strangerList(Long userId){
        return getKey(RedisKey.K107,userId);
    }


    /**
     * 当前的陌生人列表
     * @return
     */
    public static String canPickUserIdSet(){
        return getKey(RedisKey.K108);
    }

    /**
     * 正在对谁家的土地做操作
     * @return
     */
    public static String operateUserIdFarm(Long userId){
        return getKey(RedisKey.K108,userId);
    }

    /**
     * 新红包农场用户第一块地的开启时间
     * @param userId
     * @return
     */
    public static  String getNewFristLandCreate(Long userId){
        return getKey(RedisKey.K110,userId);
    }

    /**
     * 获取农场用户操作当前时间的key 精确到秒
     * @param time
     * @return
     */
    public static String getLandUsersOpt(String time){return getKey(RedisKey.K111,time);}

    /**
     * 是否好友列表迁移过邀请列表
     * @param userId
     * @return
     */
    public static  String moveInviteToFriend(Long userId){
        return getKey(RedisKey.K112,userId);
    }

    /**
     * 今日是否获取过邀请奖励金
     * @param userId
     * @return
     */
    public static  String alreadyGetInviteChange(Long userId,LocalDate localDate){
        return getKey(RedisKey.K113,userId,localDate);
    }

    /**
     * 判断今日给狗咬的次数
     * @param userId
     * @return
     */
    public static  String getDogDefeanse(Long userId,Long dogUserId,LocalDate localDate){
        return getKey(RedisKey.K114,userId,dogUserId,localDate);
    }
    /**
     * 获取用户绑定小蜜的key

     * @return
     */
    public static String  pickAssistantLastTime(Long userId){
        return getKey(RedisKey.K115,userId);
    }


    /**
     * 用户获取打狗棒的新闻Id的储存
     * @return
     */
    public static String  getDogProp(Long userId,Integer taskId,LocalDate date){
        return getKey(RedisKey.K116,userId,taskId,date);
    }




    /**
     * 用户获取打狗棒的新闻Id的储存
     * @return
     */
    public static String  getFriendAndSecondPacketIds(Long userId){
        return getKey(RedisKey.K117,userId);
    }

    /**
     * 添加好友申请
     * @return
     */
    public static String  applyFriendKey(Long userId){
        return getKey(RedisKey.K118,userId);
    }


    /**
     *
     * @return
     */
    public static String  operateFriendApply(Long userId){
        return getKey(RedisKey.K119,userId);
    }



    /**
     * 分发双倍加分布式锁
     * @return
     */
    public static String  doublePacketLock(Long userId){
        return getKey(RedisKey.K0121,userId);
    }


    /**
     * 拼手气红包预发出的redis数据
     * @return
     */
    public static String  luckPacketReady(Long userId,String timesStamp){
        return getKey(RedisKey.K122,userId,timesStamp);
    }


    /**
     * 拼手气红包预发出的redis数据
     * @return
     */
    public static String  todayGetLuckPacketTimes(String unionId,LocalDate localDate){
        return getKey(RedisKey.K123,unionId,localDate);
    }


    /**
     * 拼手气红包有待入账推送计数
     * @return
     */
    public static String  todaySendPushLuckPacketTimes(Long userId,LocalDate localDate){
        return getKey(RedisKey.K124,userId,localDate);
    }


    /**
     * 收取群红包动作上锁
     * @return
     */
    public static String  openLuckPacket(Long packetId){
        return getKey(RedisKey.K125,packetId);
    }

    /**
     * 待打tag key
     *
     * @param time
     * @return
     */
    public static String getWaitTagKey(LocalDateTime time) {
        return getKey(RedisKey.K126, time.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
    }

    /**
     * 待打tag key
     *
     * @return
     */
    public static String getWaitTagLockKey() {
        return getKey(RedisKey.K126);
    }

    /**
     * 红包待摘取
     * @return
     */
    public static String  waitPick(Long userId){
        return getKey(RedisKey.K128,userId);
    }


    /**
     *app用户玩点点赚的当日的记录
     * @param userId
     * @param localDate
     * @return
     */
    public static String  pointAppCondition(Long userId,LocalDate localDate){
        return getKey(RedisKey.K131,userId,localDate);
    }

    /**
     *微信用户当日的点点赚记录
     * @param unionId
     * @param localDate
     * @return
     */
    public static String  pointWechatCondition(String unionId,LocalDate localDate){
        return getKey(RedisKey.K132,unionId,localDate);
    }


    /**
     *打开点点赚帮助增加次数的记录
     * @param unionId
     * @param localDate
     * @return
     */
    public static String  getOpenUrlPointTime(String unionId,LocalDate localDate){
        return getKey(RedisKey.K133,unionId,localDate);
    }

    /**
     *app用户点点赚抽奖接口分布式锁
     * @param userId
     * @return
     */
    public static String  appPointPump(Long userId){
        return getKey(RedisKey.K0134,userId);
    }

    /**
     *微信用户点点赚抽奖接口分布式锁
     * @param unionId
     * @return
     */
    public static String  wechatPointPump(String unionId){
        return getKey(RedisKey.K0135,unionId);
    }


    /**
     * 点点赚用户的操作记录
     * @param time
     * @return
     */
    public static String  pointOperateRecord(String time){
        return getKey(RedisKey.K136,time);
    }

    /**
     * 用户每日任务
     * @param userId
     * @return
     */
    public static String getDailyTaskKey(Long userId) {
        return getKey(RedisKey.K140,userId,DateUtils.getDayStr(new Date()));
    }



    /**
     * 群红包用户当天发出的红包个数
     * @return
     */
    public static String  luckPacketSendTimesToday(Long userId,LocalDate localDate){
        return getKey(RedisKey.K139,userId,localDate);
    }

    /**

     * 点点赚用户提现锁
     * @return
     */
    public static String  pointWithdraw(Long userId) {
        return getKey(RedisKey.K142, userId);
    }

    /**
     * 获取签到接口分布式锁
     * @param userId
     * @return
     */
    public static String getSignInLockKey(Long userId) {
        return getKey(RedisKey.K0143,userId);

    }

    /**
     * 获取用户已读文章数量
     * @param userId
     * @return
     */
    public static String getUserAlreadyReadingKey(Long userId) {
        return getKey(RedisKey.K230,userId);
    }

    /**
     * 获取签到打卡日期文案
     * @param date
     * @return
     */
    public static String getSignInDateContent(Date date) {
        return getKey(RedisKey.K145,DateUtils.getDayStr(date));
    }

    /**
     * 获取用户打卡分享奖励领取标志
     * @param userId
     * @param date
     * @return
     */
    public static String getUserSignInShareRewardFlag(Long userId,Date date) {
        return getKey(RedisKey.K146,userId,DateUtils.getDayStr(date));
    }

    /**
     * 用户帮助别的用户增加打卡分享奖励记录
     * @param openid
     * @param date
     * @return
     */
    public static String getUserSignInShareRewardRecord(String openid,Date date) {
        return getKey(RedisKey.K147,openid,DateUtils.getDayStr(date));
    }

    /**
     * 领取日常任务锁
     * @param userId
     * @param date
     * @return
     */
    public static String getNormalPlanReward(Long userId,LocalDate date) {
        return getKey(RedisKey.K159, userId, date);
    }
    /**
     * 被邀请者对应的邀请数据key
     *
     * @param inviteeId
     * @return
     */
    public static String inviteRecordByInviteeKey(Long inviteeId) {
        return getKey(RedisKey.K157, inviteeId);
    }

    /**
     * 用户今日金币余额
     *
     * @param userId
     * @return
     */
    public static String todayCoinBalanceKey(Long userId) {
        return getKey(RedisKey.K158, userId);
    }

    /**
     * 是否初始化完新红包农场
     *
     * @param userId
     * @return
     */
    public static String initNewLandFinishKey(Long userId) {
        return getKey(RedisKey.K160, userId);
    }


    /**
     * 获取用户的可偷红包Id的key
     * @param userId
     * @return
     */
    public static String getCanStealIdListKey(Long userId) {
        return getKey(RedisKey.K179, userId);
    }


    /**
     * 将还在有效期的看门狗存入redis的key
     *
     * @param userId
     * @return
     */
    public static String farmDogKey(Long userId) {
        return getKey(RedisKey.K176, userId);
    }

    /*
     * 获取随机用户列表缓存key
     */
    public static String getRandomUserListKey(Date date) {
        return getKey(RedisKey.K166,DateUtils.getDayStr(date));
    }


    /**
     * 获取日常任务奖励接口
     * @return
     */
    public static String getNormalLockKey(Long userId) {
        return getKey(RedisKey.K171, userId);
    }

    /**
     * 缓存用户新手奖励状态
     * @return
     */
    public static String getNewTaskCache(Long userId,LocalDate localDate,Integer taskId) {
        return getKey(RedisKey.K172, userId,localDate,taskId);
    }

    /**
     * 缓存用户日常奖励状态
     * @return
     */
    public static String getNormalTaskCache(Long userId,LocalDate localDate,Integer taskId) {
        return getKey(RedisKey.K173, userId,localDate,taskId);
    }

    /**
     * 缓存登录用户手机号
     */
    public static String getLoginUserPhone(Long userId){return getKey(RedisKey.K178,userId);}

    /**
     * 获取用户任务缓存信息
     */
    public static String getUserTaskInfo(Long userId,Integer taskType){return getKey(RedisKey.K180,userId,taskType);}


    /**
     * 添加仇敌加锁
     * @return
     */
    public static String addEnemyLock(Long userId,Long enemyId ) {
        return getKey(RedisKey.K175, userId,enemyId);
    }



    /**
     * 用户签到第一天的奖励金加缓存
     * @return
     */
    public static String getFristSignReward(Long userId) {
        return getKey(RedisKey.K187, userId);
    }

    /**
     * 用户可用余额缓存key
     *
     * @param userId
     * @return
     */
    public static String userChangeBalanceCacheKey(Long userId) {
        return getKey(RedisKey.K177, userId);
    }


    /**
     * 用户获取新版解锁奖励金的缓存
     *
     * @param userId
     * @return
     */
    public static String newCashPacketCacheKey(Long userId) {
        return getKey(RedisKey.K189, userId);
    }

    /**
     * 用户已偷取红包缓存key
     * @param userId
     * @return
     */
    public static String userStolenPacketKey(Long userId) {
        return getKey(RedisKey.K195, userId);

    }

    /**
     * 用户金币日余额记录id缓存
     *
     * @param userId
     * @param localDate
     * @return
     */
    public static String userDailyRecordIdCacheKey(Long userId, LocalDate localDate) {
        return getKey(RedisKey.K184, userId, localDate);
    }

        /**
         * 用户验证信息缓存(用户id)
         *
         * @return
         */
    public static String userWechatCheckInfoForUserId(Long userId) {
        return getKey(RedisKey.K185,userId);
    }


    /**
     * 用户验证信息缓存(openid)
     *
     * @return
     */
    public static String userWechatCheckInfoForOpenId(String openId) {
        return getKey(RedisKey.K186,openId);
    }

    /**
     * 用户现金红包
     */
    public static String getUserCashPacketKey(Long userId) {
        return getKey(RedisKey.K181,userId);
    }

    /**
     * 用户极光注册id
     */
    public static String getUserJiGuangRegistrationId(Long userId) {
        return getKey(RedisKey.K183,userId);
    }

    /**
     * 签到获取IMEI码分布式锁
     * @param deviceId
     * @param imei
     * @return
     */
    public static String getDeviceIMEIKey(String deviceId, String imei) {
        return getKey(RedisKey.K191, deviceId, imei);
    }

    /**
     * 极光推送插入regId分布式锁
     * @param deviceId
     * @param regId
     * @return
     */
    public static String getDeviceRegIdKey(String deviceId, String regId) {
        return getKey(RedisKey.K198, deviceId, regId);
    }

    /**
     * 获取用户最新的一个将要成熟红包
     */
    public static String lastRipePacketKey(Long userId) {
        return getKey(RedisKey.K190,userId);
    }


    /**
     * 获取任务体系接口
     */
    public static String getTaskByUserId(Long userId) {
        return getKey(RedisKey.K192,userId);
    }


    /**
     * 获取今日是否初始化过日常任务
     */
    public static String getHaveInitTask(Long userId,LocalDate localDate) {
        return getKey(RedisKey.K205,userId,localDate);
    }

    /**
     * 获取任务体系接口
     */
    public static String initTaskLock(Long userId) {
        return getKey(RedisKey.K206, userId);
    }

        /*
     * 用户详情缓存
     *
     * @param userId
     * @return
     */
    public static String getUserCacheKey(Long userId) {
        return getKey(RedisKey.K200, userId);
    }

    /**
     * 用户土地缓存
     *
     * @param userId
     * @return
     */
    public static String getUserLandCacheKey(Long userId) {
        return getKey(RedisKey.K201, userId);
    }

    /**
     * 用户行为缓存
     */
    public static String getUserActionCacheKey(Long userId,Integer actionType) {
        return getKey(RedisKey.K202,userId,actionType);
    }

    /**
     * 获取我的页面配置列表平台
     */
    public static String getOwnPageConfigKey(Integer platform) {
        return getKey(RedisKey.K221,platform);
    }

    /**
     * 新人引导阅读奖励未完成标志
     */
    public static String getNewUserReadingGuideKey(Long userId) {
        return getKey(RedisKey.K226,userId);
    }

    /**
     * 被邀请者的被邀请记录
     * @param userId
     * @return
     */
    public static String getInviteeCacheKey(Long userId) {
        return getKey(RedisKey.K222, userId);
    }



    /**
     * 用户土获取到的打狗棒数量
     *
     * @param userId
     * @return
     */
    public static String getDogStitckKey(Long userId) {
        return getKey(RedisKey.K225, userId);
    }

    /**
     * 用户行为批量更新集合
     */
    public static String getUserActionUpdateSetKey(int userActionType,Date date,Long userId) {
        Long num = userId % 1024;
        String tb = num.toString();
        if (num < 10L) {
            tb = "000" + num;
        } else if (num >= 10L && num < 100L) {
            tb = "00" + num;
        } else if (num >= 100L && num < 1000L) {
            tb = "0" + num;
        }
        return getKey(RedisKey.K229,userActionType,DateUtils.getDayStr(date),tb);
    }

    public static String getRateKey(Date date) {
        return getKey(RedisKey.K227,DateUtils.getDayNumber(date));
    }


    /**
     * 用户插入领取特权券的记录
     * @param userId
     * @return
     */
    public static String getInsertTicketKey(Long userId) {
        return getKey(RedisKey.K242,userId);
    }

    private static String getKey(RedisKey redisKey, Object... objects) {
        return getKey(NC_PREFIX, redisKey, objects);
    }

    private static String getKey(String prefix, RedisKey redisKey, Object... objects) {


        Joiner joiner = Joiner.on(SEPARATOR).skipNulls();
        List<Object> items = new ArrayList<>();
        items.add(prefix);
        items.add(redisKey);
        items.addAll(Arrays.stream(objects).map(value -> value == null ? "null" : value).collect(Collectors.toList()));
        return joiner.join(items);

    }

    private RedisKeyUtil() {
        // 不允许创建实例
    }

   
}
