package cn.com.duiba.tuia.news.center.constant;

import cn.com.duiba.tuia.news.center.enums.DataBase;
import org.springframework.transaction.PlatformTransactionManager;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: TransactionManagerRegister.java , v 0.1 2018/7/9 下午9:42 ZhouFeng Exp $
 */
public class TransactionManagerRegister {

    private static final Map<PlatformTransactionManager, Set<DataBase>> MAPPER = new HashMap<>(16);

    private TransactionManagerRegister() {
    }

    /**
     * 事务注册
     *
     * @param transactionTemplate
     * @param dataBaseSet
     */
    public static void register(PlatformTransactionManager transactionTemplate, DataBase... dataBaseSet) {
        MAPPER.put(transactionTemplate, new HashSet<>(Arrays.asList(dataBaseSet)));
    }

    /**
     * 事务关联表查询
     *
     * @param transactionTemplate
     * @return
     */
    public static Set<DataBase> relateBase(PlatformTransactionManager transactionTemplate) {
        return MAPPER.get(transactionTemplate);
    }


}
