/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.util;

import cn.com.duiba.tuia.news.center.util.PhoneNumberInfo;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.springframework.core.io.ClassPathResource;

public class PhoneNumberGeo {
    private static final String[] PHONE_NUMBER_TYPE = new String[]{null, "\u7ec9\u8bf2\u59e9", "\u9471\u65c8\ufffd\ufffd", "\u9422\u5178\u4fca", "\u9422\u5178\u4fca\u94cf\u6c2d\u5ad9\u6769\u612f\u60c0\u935f\ufffd", "\u9471\u65c8\ufffd\u6c33\u6ac4\u93b7\u71bb\u7e4d\u9480\u30e5\u6662", "\u7ec9\u8bf2\u59e9\u94cf\u6c2d\u5ad9\u6769\u612f\u60c0\u935f\ufffd"};
    private static final int INDEX_SEGMENT_LENGTH = 9;
    private static final int DATA_FILE_LENGTH_HINT = 3747505;
    private static byte[] dataByteArray;
    private static int indexAreaOffset;
    private static int phoneRecordCount;
    private ByteBuffer byteBuffer;

    private static synchronized void initData(String datePath) {
        if (dataByteArray == null) {
            ByteArrayOutputStream byteData = new ByteArrayOutputStream(3747505);
            byte[] buffer = new byte[1024];
            try (InputStream inputStream = new ClassPathResource(datePath).getInputStream();){
                int readBytesLength;
                while ((readBytesLength = inputStream.read(buffer)) != -1) {
                    byteData.write(buffer, 0, readBytesLength);
                }
            }
            catch (Exception e) {
                System.err.println("Can't find phone.dat in classpath: " + datePath);
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            dataByteArray = byteData.toByteArray();
            ByteBuffer byteBuffer = ByteBuffer.wrap(dataByteArray);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int dataVersion = byteBuffer.getInt();
            indexAreaOffset = byteBuffer.getInt();
            phoneRecordCount = (dataByteArray.length - indexAreaOffset) / 9;
        }
    }

    public PhoneNumberGeo(String dataPath) {
        PhoneNumberGeo.initData(dataPath);
        this.byteBuffer = ByteBuffer.wrap(dataByteArray);
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public PhoneNumberInfo lookup(String phoneNumber) {
        int phoneNumberPrefix;
        if (phoneNumber == null || phoneNumber.length() > 11 || phoneNumber.length() < 7) {
            return null;
        }
        try {
            phoneNumberPrefix = Integer.parseInt(phoneNumber.substring(0, 7));
        }
        catch (Exception e) {
            return null;
        }
        int left = 0;
        int right = phoneRecordCount;
        while (left <= right) {
            int middle = left + right >> 1;
            int currentOffset = indexAreaOffset + middle * 9;
            if (currentOffset >= dataByteArray.length) {
                return null;
            }
            this.byteBuffer.position(currentOffset);
            int currentPrefix = this.byteBuffer.getInt();
            if (currentPrefix > phoneNumberPrefix) {
                right = middle - 1;
                continue;
            }
            if (currentPrefix < phoneNumberPrefix) {
                left = middle + 1;
                continue;
            }
            int infoBeginOffset = this.byteBuffer.getInt();
            byte phoneType = this.byteBuffer.get();
            int infoLength = -1;
            for (int i = infoBeginOffset; i < indexAreaOffset; ++i) {
                if (dataByteArray[i] != 0) continue;
                infoLength = i - infoBeginOffset;
                break;
            }
            String infoString = new String(dataByteArray, infoBeginOffset, infoLength, StandardCharsets.UTF_8);
            String[] infoSegments = infoString.split("\\|");
            PhoneNumberInfo phoneNumberInfo = new PhoneNumberInfo();
            phoneNumberInfo.setPhoneNumber(phoneNumber);
            phoneNumberInfo.setProvince(infoSegments[0]);
            phoneNumberInfo.setCity(infoSegments[1]);
            phoneNumberInfo.setZipCode(infoSegments[2]);
            phoneNumberInfo.setAreaCode(infoSegments[3]);
            phoneNumberInfo.setPhoneType(PHONE_NUMBER_TYPE[phoneType]);
            return phoneNumberInfo;
        }
        return null;
    }

    public static void main(String[] args) {
        PhoneNumberGeo phoneNumberGeo = new PhoneNumberGeo(args[0]);
        Scanner scanner = new Scanner(System.in);
        while (scanner.hasNext()) {
            System.out.println(phoneNumberGeo.lookup(scanner.next()));
        }
    }
}

