package cn.com.duiba.tuia.pangea.center.api.req;

import cn.com.duiba.tuia.pangea.center.api.dto.TestGroupDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author fenglijun
 * @version 1.0
 * @since 2019-09-03 17:08
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PlanUpdateReq {

    private Long id;

    @ApiModelProperty(value = "对照组活动id", required = true)
    private String controlGroup;

    @ApiModelProperty(value = "对照组活动占比", required = true)
    private Integer controlPercent;

    @ApiModelProperty(value = "测试计划开始时间", required = true)
    private String startTime;

    @ApiModelProperty(value = "测试计划结束时间", required = true)
    private String endTime;

    @ApiModelProperty(value = "流量选择类型", required = true)
    private Integer flowType;

    @ApiModelProperty(value = "测试人", required = true)
    private String testName;

    @ApiModelProperty(value = "测试组", required = true)
    private List<TestGroupDto> testGroup;

    private String slotJson;
}
