/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import cn.com.duiba.wolf.entity.Pair;
import cn.com.duiba.wolf.utils.Base58;
import cn.com.duiba.wolf.utils.SoftValueHashMap;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class BlowfishUtils {
    private static final String CIPHER_NAME = "Blowfish/CFB8/NoPadding";
    private static final String KEY_SPEC_NAME = "Blowfish";
    private static final ThreadLocal<SoftValueHashMap<String, Pair<Cipher, Cipher>>> pool = new ThreadLocal();

    private BlowfishUtils() {
    }

    public static String encryptBlowfish(String str, String key) {
        Cipher enCipher = BlowfishUtils.getInstance(key).getKey();
        String result = null;
        if (StringUtils.isNotBlank((String)str)) {
            try {
                byte[] encrypted = enCipher.doFinal(str.getBytes());
                result = Base58.encode(encrypted);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    public static String decryptBlowfish(String str, String key) {
        Cipher deCipher = BlowfishUtils.getInstance(key).getValue();
        String result = null;
        if (StringUtils.isNotBlank((String)str)) {
            try {
                byte[] decrypted = Base58.decode(str);
                result = new String(deCipher.doFinal(decrypted));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    @Deprecated
    public static String encryptBlowfish(String s) {
        return BlowfishUtils.encryptBlowfish(s, "abc");
    }

    @Deprecated
    public static String decryptBlowfish(String s) {
        return BlowfishUtils.decryptBlowfish(s, "abc");
    }

    private static Pair<Cipher, Cipher> getInstance(String key) {
        Pair<Cipher, Cipher> instance;
        SoftValueHashMap<String, Pair<Cipher, Cipher>> keyMap = pool.get();
        if (keyMap == null || keyMap.isEmpty()) {
            keyMap = new SoftValueHashMap();
            pool.set(keyMap);
        }
        if ((instance = keyMap.get(key)) == null) {
            String iv = StringUtils.substring((String)DigestUtils.md5Hex((String)key), (int)0, (int)8);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), KEY_SPEC_NAME);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.getBytes());
            try {
                Cipher enCipher = Cipher.getInstance(CIPHER_NAME);
                Cipher deCipher = Cipher.getInstance(CIPHER_NAME);
                enCipher.init(1, (Key)secretKeySpec, ivParameterSpec);
                deCipher.init(2, (Key)secretKeySpec, ivParameterSpec);
                instance = new Pair<Cipher, Cipher>(enCipher, deCipher);
            }
            catch (Exception e) {
                throw new IllegalStateException("\u521d\u59cb\u5316\u5931\u8d25", e);
            }
            keyMap.put(key, instance);
        }
        return instance;
    }
}

