/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class DeflateUtils {
    public static byte[] compress(String message) {
        return DeflateUtils.compress(message, 1);
    }

    public static byte[] compress(String message, int level) {
        return DeflateUtils.compress(DeflateUtils.stringToByte(message), level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] compress(byte[] input, int level) {
        if (ArrayUtils.isEmpty((byte[])input)) {
            return input;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(level);
        try {
            deflater.setInput(input);
            deflater.finish();
            byte[] buf = new byte[2048];
            while (!deflater.finished()) {
                int count = deflater.deflate(buf);
                bos.write(buf, 0, count);
            }
            deflater.end();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)bos);
        }
        return bos.toByteArray();
    }

    public static byte[] uncompress(byte[] input) {
        if (ArrayUtils.isEmpty((byte[])input)) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Inflater inflater = new Inflater();
        try {
            inflater.setInput(input);
            byte[] buf = new byte[2048];
            while (!inflater.finished()) {
                int count = inflater.inflate(buf);
                bos.write(buf, 0, count);
            }
        }
        catch (DataFormatException e) {
            throw new RuntimeException(e);
        }
        finally {
            inflater.end();
            IOUtils.closeQuietly((OutputStream)bos);
        }
        return bos.toByteArray();
    }

    public static String uncompressToString(byte[] input) {
        return DeflateUtils.byteToString(DeflateUtils.uncompress(input));
    }

    private static byte[] stringToByte(String str) {
        if (StringUtils.isNotBlank((String)str)) {
            return str.getBytes(Charset.forName("UTF-8"));
        }
        return null;
    }

    private static String byteToString(byte[] bytes) {
        if (ArrayUtils.isNotEmpty((byte[])bytes)) {
            return new String(bytes, Charset.forName("UTF-8"));
        }
        return null;
    }
}

