/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.utils;

import com.google.common.primitives.UnsignedBytes;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.util.IPAddressUtil;

public class NetUtils {
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);
    public static final String ANYHOST = "0.0.0.0";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static volatile String localIP = null;
    private static final byte SECTION_1 = 10;
    private static final short SECTION_2 = 172;
    private static final byte SECTION_3 = 16;
    private static final byte SECTION_4 = 31;
    private static final short SECTION_5 = 192;
    private static final short SECTION_6 = 168;
    private static final byte SECTION_7 = 100;
    private static final byte SECTION_8 = 64;
    private static final byte SECTION_9 = 127;
    private static final short SECTION_10 = 169;
    private static final short SECTION_11 = 254;
    private static final short SECTION_12 = 192;
    private static final byte SECTION_13 = 0;
    private static final byte SECTION_14 = 2;
    private static final byte SECTION_15 = 88;
    private static final byte SECTION_16 = 99;
    private static final short SECTION_17 = 198;
    private static final byte SECTION_18 = 18;
    private static final byte SECTION_19 = 19;
    private static final byte SECTION_20 = 51;
    private static final byte SECTION_21 = 100;
    private static final short SECTION_22 = 203;
    private static final byte SECTION_23 = 0;
    private static final byte SECTION_24 = 113;
    private static final short SECTION_25 = 224;
    private static final short SECTION_26 = 239;
    private static final short SECTION_27 = 240;
    private static final short SECTION_28 = 255;
    private static final short SECTION_29 = 255;
    private static final byte SECTION_30 = 0;
    private static final byte SECTION_31 = 127;

    private NetUtils() {
    }

    public static String getLocalIp() {
        Enumeration<NetworkInterface> netInterfaces;
        if (localIP != null) {
            return localIP;
        }
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            if (NetUtils.isValidLocalAddress(localAddress)) {
                localIP = localAddress.getHostAddress();
                return localIP;
            }
        }
        catch (Throwable e) {
            log.warn("Failed to retriving ip address, " + e.getMessage(), e);
        }
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.error("getLocalIp error", (Throwable)e);
            return null;
        }
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress ip = address.nextElement();
                if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(58) != -1) continue;
                localIP = ip.getHostAddress();
                return localIP;
            }
        }
        return localIP;
    }

    private static boolean isValidLocalAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress() || !address.isSiteLocalAddress()) {
            return false;
        }
        if (address instanceof Inet6Address) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    public static boolean isLanIp(String ip) {
        byte[] addr = IPAddressUtil.textToNumericFormatV4(ip);
        return NetUtils.isLanIp(addr);
    }

    public static boolean isReservedIp(String ip) {
        byte[] addr = IPAddressUtil.textToNumericFormatV4(ip);
        return NetUtils.isReservedIp(addr);
    }

    private static boolean isLanIp(byte[] addr) {
        if (addr == null || addr.length < 2) {
            return false;
        }
        int b0 = UnsignedBytes.toInt((byte)addr[0]);
        int b1 = UnsignedBytes.toInt((byte)addr[1]);
        if (b0 == 10) {
            return true;
        }
        if (b0 == 172 && b1 >= 16 && b1 <= 31) {
            return true;
        }
        return b0 == 192 && b1 == 168;
    }

    private static boolean isReservedIp(byte[] addr) {
        if (addr == null || addr.length < 2) {
            return false;
        }
        int b0 = UnsignedBytes.toInt((byte)addr[0]);
        int b1 = UnsignedBytes.toInt((byte)addr[1]);
        int b2 = UnsignedBytes.toInt((byte)addr[2]);
        int b3 = UnsignedBytes.toInt((byte)addr[3]);
        if (b0 == 10) {
            return true;
        }
        if (b0 == 172 && b1 >= 16 && b1 <= 31) {
            return true;
        }
        if (b0 == 192 && b1 == 168) {
            return true;
        }
        if (b0 == 100 && b1 >= 64 && b1 <= 127) {
            return true;
        }
        if (b0 == 169 && b1 == 254) {
            return true;
        }
        if (b0 == 192 && b1 == 0 && (b2 == 0 || b2 == 2)) {
            return true;
        }
        if (b0 == 192 && b1 == 88 && b2 == 99) {
            return true;
        }
        if (b0 == 198 && b1 >= 18 && b1 <= 19) {
            return true;
        }
        if (b0 == 198 && b1 == 51 && b2 == 100) {
            return true;
        }
        if (b0 == 203 && b1 == 0 && b2 == 113) {
            return true;
        }
        if (b0 >= 224 && b0 <= 239) {
            return true;
        }
        if (b0 >= 240 && b1 <= 255) {
            return true;
        }
        if (b0 == 255 && b1 == 255 && b2 == 255 && b3 == 255) {
            return true;
        }
        if (b0 == 0) {
            return true;
        }
        return b0 == 127;
    }
}

