package cn.com.duiba.tuia.pangea.center.api.rsp.newactivity;

import cn.com.duiba.tuia.pangea.center.api.dto.newactivity.TestActivityNewDTO;
import cn.com.duiba.tuia.pangea.center.api.dto.resource.TestResourceFlowDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 新活动测试-–用于编辑或追加投放的测试计划配置数据返回
 * @author miaohongshuai
*/
@Data
public class NewActivityTestSelectForUpdateRsp implements Serializable {

    private static final long serialVersionUID = 4030586835381738750L;
    @ApiModelProperty(value = "测试计划ID")
    private Long id;

    @ApiModelProperty(value = "测试计划名称", required = true, dataType = "string")
    private String planName;

    @ApiModelProperty(value = "测试计划开始时间", required = true)
    private Date startTime;

    @ApiModelProperty(value = "测试计划结束时间", required = true)
    private Date endTime;

    @ApiModelProperty(value = "测试人", required = true)
    private String testName;

    @ApiModelProperty(value = "测试人adminId")
    private Long adminId;

    @ApiModelProperty(value = "测试挑选的广告位列表")
    private List<Long> selectSlotIds;

    @ApiModelProperty(value = "已选广告位个数")
    private Integer slotNum;

    @ApiModelProperty(value = "已选广告位测试访问UV")
    private Long totalSlotNum;

    @ApiModelProperty(value = "测试组配置")
    private List<TestActivityNewDTO> testGroupList;
}
