package cn.com.duiba.tuia.pangea.center.api.enums;

import lombok.Getter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 测试类型，0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层
 * @author miaohongshuai
*/
public enum TestTypeEnum {
    ACTIVITY_TEST(0, "活动ABTest"),
    BUOY_TEST(1, "浮标ABTest"),
    PULL_TEST(2, "下拉ABTest"),
    BACK_TEST(3, "返回拦截ABTest"),
    NEW_ACTIVITY_TEST(4, "新活动测试"),
    RESPONSIVE_PLUGIN_TEST(11, "响应式插件ABTest"),
    LAYER_TEST(21, "弹层ABTest");

    @Getter
    private Integer testType;
    @Getter
    private String desc;

    TestTypeEnum(Integer testType, String desc) {
        this.testType = testType;
        this.desc = desc;
    }

    private static Map<Integer, TestTypeEnum> testTypeEnumMap;
    static {
        testTypeEnumMap = new HashMap<>(8);
        TestTypeEnum[] testTypeEnums = TestTypeEnum.values();
        for (TestTypeEnum testTypeEnum : testTypeEnums) {
            testTypeEnumMap.put(testTypeEnum.getTestType(), testTypeEnum);
        }
    }

    public static TestTypeEnum getEnumByTestType(Integer testType) {
        return testTypeEnumMap.get(testType);
    }

    public static List<Integer> listResourceTestTypes() {
        List<Integer> result = new ArrayList<>();
        result.add(BUOY_TEST.getTestType());
        result.add(PULL_TEST.getTestType());
        result.add(BACK_TEST.getTestType());
        result.add(RESPONSIVE_PLUGIN_TEST.getTestType());
        result.add(LAYER_TEST.getTestType());
        // 与一期也互斥
        result.add(ACTIVITY_TEST.getTestType());
        return result;
    }
}
