package cn.com.duiba.tuia.pangea.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.pangea.center.api.req.resource.ResourceFlowTestAddOrUpdateReq;
import cn.com.duiba.tuia.pangea.center.api.req.resource.ResourceFlowTestListReq;
import cn.com.duiba.tuia.pangea.center.api.req.resource.ResourceFlowTestSingleUpdateReq;
import cn.com.duiba.tuia.pangea.center.api.rsp.resource.ResourceFlowTestListRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.resource.ResourceFlowTestSelectForUpdateRsp;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 *
 * @author miaohongshuai
*/
@AdvancedFeignClient
public interface RemoteResourceFlowTestService {

    /**
     * 广告位活动的资源测试 新增或更新
     * @param req
     * @return
     */
    DubboResult<Long> addOrUpdatePlan(ResourceFlowTestAddOrUpdateReq req);

    /**
     * 广告位活动的资源测试组列表查询
     * @param resourceFlowTestListReq
     * @return
     */
    PageResultDto<ResourceFlowTestListRsp> listResourceFlowTest(ResourceFlowTestListReq resourceFlowTestListReq);

    /**
     * 单个测试组配置修改
     * @param req
     * @return
     */
    Boolean updateResourceFlowTest(ResourceFlowTestSingleUpdateReq req);

    /**
     * 获取测试计划下的广告位+活动 活动访问UV配置
     * @param slotId
     * @param activityId
     * @param planId
     * @param testVisitorRatio 测试占比
     * @return 测试占比
     */
    ResourceFlowTestListRsp getResourceFlowTest(Long slotId, Long activityId, Long planId, Integer testVisitorRatio);


    /**
     * 批量修改广告位+活动占比和测试组占比
     * @param req
     * @return
     */
    Boolean batchUpdateResourceFlowTest(ResourceFlowTestSingleUpdateReq req);

    /**
     * 根据测试计划id 查询测试计划配置
     * @param planId
     * @return
     */
    ResourceFlowTestSelectForUpdateRsp queryResourceByPlanId(Long planId);
}
