/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.UriTemplate;
import springfox.documentation.spring.web.PropertySourcedMapping;

public class PropertySourcedRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    private final Map<String, HandlerMethod> handlerMethods = new LinkedHashMap<String, HandlerMethod>();
    private final Environment environment;
    private final Object handler;

    public PropertySourcedRequestMappingHandlerMapping(Environment environment, Object handler) {
        this.environment = environment;
        this.handler = handler;
    }

    protected void initHandlerMethods() {
        this.logger.debug((Object)"initialising the handler methods");
        this.setOrder(-2147482648);
        Class<?> clazz = this.handler.getClass();
        if (this.isHandler(clazz)) {
            for (Method method : clazz.getMethods()) {
                PropertySourcedMapping mapper = (PropertySourcedMapping)AnnotationUtils.getAnnotation((Method)method, PropertySourcedMapping.class);
                if (mapper == null) continue;
                RequestMappingInfo mapping = this.getMappingForMethod(method, clazz);
                HandlerMethod handlerMethod = this.createHandlerMethod(this.handler, method);
                String mappingPath = this.mappingPath(mapper);
                if (mappingPath != null) {
                    this.logger.info((Object)String.format("Mapped URL path [%s] onto method [%s]", mappingPath, handlerMethod.toString()));
                    this.handlerMethods.put(mappingPath, handlerMethod);
                    continue;
                }
                for (String path : mapping.getPatternsCondition().getPatterns()) {
                    this.logger.info((Object)String.format("Mapped URL path [%s] onto method [%s]", path, handlerMethod.toString()));
                    this.handlerMethods.put(path, handlerMethod);
                }
            }
        }
    }

    private String mappingPath(PropertySourcedMapping mapper) {
        final String key = mapper.propertyKey();
        return (String)Optional.fromNullable((Object)this.environment.getProperty(key)).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                return input.replace(String.format("${%s}", key), input);
            }
        }).orNull();
    }

    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, Controller.class) != null || AnnotationUtils.findAnnotation(beanType, RequestMapping.class) != null;
    }

    protected HandlerMethod lookupHandlerMethod(String urlPath, HttpServletRequest request) throws Exception {
        this.logger.debug((Object)("looking up handler for path: " + urlPath));
        HandlerMethod handlerMethod = this.handlerMethods.get(urlPath);
        if (handlerMethod != null) {
            return handlerMethod;
        }
        for (String path : this.handlerMethods.keySet()) {
            UriTemplate template = new UriTemplate(path);
            if (!template.matches(urlPath)) continue;
            request.setAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, (Object)template.match(urlPath));
            return this.handlerMethods.get(path);
        }
        return null;
    }
}

