/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;

public class JarVersionUtils {
    private static final String MF = "META-INF/MANIFEST.MF";
    private static final String VERSION_PREFIX = "Implementation-Version: ";
    private static final String BUNDLE_VERSION_PREFIX = "Bundle-Version: ";

    private JarVersionUtils() {
    }

    public static String getJarVersion(Class clazz) {
        Package pkg = clazz.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    public static String getJedisVersion() {
        String jedisVersion = null;
        try {
            ClassLoader classLoader = JarVersionUtils.class.getClassLoader();
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(MF) : ClassLoader.getSystemResources(MF);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                BufferedInputStream in = new BufferedInputStream(url.openStream());
                LineIterator iter = IOUtils.lineIterator((InputStream)in, (Charset)Charset.forName("ISO-8859-1"));
                String version = null;
                boolean isMatch = false;
                while (iter.hasNext()) {
                    String line = iter.next();
                    if (line == null) continue;
                    if (line.equals("Bundle-Name: Jedis")) {
                        isMatch = true;
                    } else if (line.startsWith(BUNDLE_VERSION_PREFIX)) {
                        version = line.substring(BUNDLE_VERSION_PREFIX.length());
                    }
                    if (!isMatch || version == null) continue;
                    break;
                }
                if (!isMatch || version == null) continue;
                jedisVersion = version;
                break;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return jedisVersion;
    }

    public static boolean isJarVersionEqualOrGreaterThan(String currentVersion, String baseVersion) {
        if (StringUtils.isBlank((String)currentVersion) || StringUtils.isBlank((String)baseVersion)) {
            return false;
        }
        Integer[] currentVersionArr = JarVersionUtils.normalization(currentVersion);
        if (currentVersionArr == null) {
            return false;
        }
        Integer[] baseVersionArr = JarVersionUtils.normalization(baseVersion);
        if (baseVersionArr == null) {
            return false;
        }
        int minLen = Math.min(currentVersionArr.length, baseVersionArr.length);
        for (int i = 0; i < minLen; ++i) {
            if (currentVersionArr[i] > baseVersionArr[i]) {
                return true;
            }
            if (currentVersionArr[i] >= baseVersionArr[i]) continue;
            return false;
        }
        return currentVersionArr.length >= baseVersionArr.length;
    }

    private static Integer[] normalization(String v) {
        if (v.contains("-")) {
            v = v.substring(0, v.indexOf(45));
        }
        String[] vs = StringUtils.split((String)v, (char)'.');
        ArrayList<Integer> vsList = new ArrayList<Integer>();
        for (int i = 0; i < vs.length; ++i) {
            String v1 = vs[i];
            if (JarVersionUtils.isInteger(v1)) {
                vsList.add(Integer.parseInt(v1));
                continue;
            }
            if (i >= vs.length - 1) continue;
            return null;
        }
        return vsList.toArray(new Integer[vsList.size()]);
    }

    private static boolean isInteger(String str) {
        if (StringUtils.isBlank((String)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
}

