package cn.com.duiba.tuia.pangea.center.api.dto.appslot;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * @author yuantong
 * @version 1.0
 * @since 2019-09-06 15:18
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class MediaManagerDto implements Serializable {
    private static final long serialVersionUID = 3070939046156494326L;
    /**
     * 媒体账号Id
     */
    private Long mediaId;
    /**
     * 运营id
     */
    private Long managerId;
    /**
     * 运营姓名
     */
    private String managerName;
    /**
     * 运营类型 0为媒体运营 1为媒介
     */
    private Integer managerType;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
