package cn.com.duiba.tuia.pangea.center.api.rsp.newactivity;

import cn.com.duiba.tuia.pangea.center.api.dto.newactivity.TestActivityNewDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 *  编辑测试活动信息--广告位列表响应数据
 * @author miaohongshuai
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class NewActivityTestListRsp implements Serializable {

    private static final long serialVersionUID = -1321181539615997004L;

    /**
     * 媒体ID
     */
    private Long appId;
    /**
     * 媒体名称
     */
    private String appName;
    /**
     * 广告位ID
     */
    private Long slotId;
    /**
     * 广告位名称
     */
    private String slotName;
    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 测试计划ID
     */
    private Long planId;
    /**
     * 测试类型，默认0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层
     */
    private Integer testType;
    /**
     * 测试总量级
     */
    private Long testTotalAccessUv;
    /**
     * 测试组信息
     */
    List<TestActivityNewDTO> testGroupList;
}
