package cn.com.duiba.tuia.pangea.center.api.remoteservice.spread;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.pangea.center.api.dto.spread.SpreadDTO;

import java.util.List;
import java.util.Set;

/**
 * 铺量计划
 */
@AdvancedFeignClient
public interface RemoteSpreadService {

    List<SpreadDTO> getListByIds(Set<Long> ids);

    SpreadDTO getSpreadById(Long id);

    List<Long> getIdsByNameLike(String name);

    PageResultDto<SpreadDTO> page(SpreadDTO dto);

    Long addSpread(SpreadDTO dto);

    void stopSpread(Long id, Long adminId, Integer spreadStatus, Integer spreadActivityStatus);

    void startSpread(Long id, Long adminId, Integer spreadStatus, Integer spreadActivityStatus);

    void approval(Long spreadId);

    List<Long> getSlotByActivityId(Long activityId);
}
