/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.spring.velocity;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.tools.ClassUtils;
import org.apache.velocity.tools.generic.SafeConfig;
import org.apache.velocity.tools.generic.ValueParser;

public class StaticFieldTool
extends SafeConfig {
    public static final String INCLUDE_KEY = "include";
    public static final String STORE_DYNAMIC_KEY = "storeDynamicLookups";
    private static final Object NULL = new Object();
    protected Log log;
    protected HashMap storage = new HashMap();
    protected boolean storeDynamicLookups = true;

    protected void configure(ValueParser values) {
        this.log = (Log)values.getValue("log");
        String[] classnames = values.getStrings(INCLUDE_KEY);
        if (classnames != null) {
            String[] arr = classnames;
            int len = classnames.length;
            for (int i = 0; i < len; ++i) {
                String classname = arr[i];
                if (this.in(classname) != null) continue;
                throw new RuntimeException("Could not find " + classname + " in the classpath");
            }
        }
        this.storeDynamicLookups = values.getBoolean(STORE_DYNAMIC_KEY, this.storeDynamicLookups);
    }

    public Object get(String name) {
        Object o = this.simpleGet(name);
        if (o != null) {
            return o == NULL ? null : o;
        }
        if (name.indexOf(46) != -1) {
            int lastDot = name.lastIndexOf(46);
            String classname = name.substring(0, lastDot);
            if (this.in(classname) == null) {
                throw new RuntimeException("Could not find " + classname + " in the classpath");
            }
            o = this.simpleGet(name);
            return o == NULL ? null : o;
        }
        return o;
    }

    private Object simpleGet(String name) {
        Object o = this.storage.get(name);
        if (o instanceof MutableField) {
            Object ret = ((MutableField)o).getValue();
            if (ret == null) {
                return NULL;
            }
            return ret;
        }
        return o;
    }

    public FieldToolSub in(String classname) {
        try {
            return this.in(ClassUtils.getClass((String)classname));
        }
        catch (ClassNotFoundException var3) {
            return null;
        }
    }

    public FieldToolSub in(Object instance) {
        return instance == null ? null : this.in(instance.getClass());
    }

    public FieldToolSub in(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Map<String, Object> results = this.inspect(clazz);
        if (this.storeDynamicLookups && !results.isEmpty()) {
            this.storage.putAll(results);
        }
        return new FieldToolSub(results);
    }

    protected Map<String, Object> inspect(Class clazz) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Field field : clazz.getFields()) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            if (this.log != null && this.log.isDebugEnabled() && results.containsKey(field.getName())) {
                this.log.debug((Object)("StaticFieldTool: " + field.getName() + " is being overridden by " + clazz.getName()));
            }
            if (Modifier.isFinal(mod)) {
                results.put(clazz.getName() + "." + field.getName(), StaticFieldTool.retrieve(field, clazz, this.log));
                continue;
            }
            results.put(clazz.getName() + "." + field.getName(), new MutableField(field, clazz, this.log));
        }
        return results;
    }

    protected static Object retrieve(Field field, Class clazz, Log log) {
        try {
            return field.get(clazz);
        }
        catch (IllegalAccessException var4) {
            if (log != null) {
                log.warn((Object)("IllegalAccessException while trying to access " + field.getName()), (Throwable)var4);
            }
            return null;
        }
    }

    public static class FieldToolSub {
        private final Map<String, Object> results;

        public FieldToolSub(Map<String, Object> results) {
            if (results == null) {
                throw new NullPointerException("Cannot create sub with null field results map");
            }
            this.results = results;
        }

        public Object get(String name) {
            Object o = this.results.get(name);
            return o instanceof MutableField ? ((MutableField)o).getValue() : o;
        }

        public String toString() {
            return this.results.toString();
        }
    }

    public static class MutableField {
        private final Class clazz;
        private final Field field;
        private final Log log;

        public MutableField(Field f, Class c, Log l) {
            if (f == null || c == null) {
                throw new NullPointerException("Both Class and Field must NOT be null");
            }
            this.field = f;
            this.clazz = c;
            this.log = l;
        }

        public Object getValue() {
            return StaticFieldTool.retrieve(this.field, this.clazz, this.log);
        }
    }
}

