/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.utils;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarningUtils {
    private static final Logger logger = LoggerFactory.getLogger(WarningUtils.class);
    private static final LoadingCache<String, AtomicInteger> markName2CountCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).maximumSize(10000L).build(key -> new AtomicInteger());

    private WarningUtils() {
    }

    public static void markThresholdWarning(String markName, int warnThreshold) {
        AtomicInteger errorCount = (AtomicInteger)markName2CountCache.get((Object)markName);
        int count = errorCount.incrementAndGet();
        if (count == warnThreshold) {
            logger.error("#onealert# \u68c0\u6d4b\u5230 markName:{} \u572810\u79d2\u5185\u9519\u8bef\u6b21\u6570\u8d85\u8fc7{}\u6b21\uff0c\u8bf7\u786e\u8ba4", new Object[]{markName, warnThreshold, new IllegalStateException("\u9519\u8bef\u6b21\u6570\u8fc7\u591a")});
        }
    }
}

