/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.dubbo;

import cn.com.duiba.wolf.dubbo.EnvInfo;
import cn.com.duiba.wolf.dubbo.VersionCheck;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.context.ApplicationContext;

public class InitOperation {
    private static final Logger LOG = LoggerFactory.getLogger(InitOperation.class);
    private static volatile boolean initialized = false;
    private static final String DEFAULT_PATH = "/META-INF/wolf/wolf.properties";
    public static final int DEFAULT_THRESHOLD = 500;

    private InitOperation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() {
        if (initialized) {
            return;
        }
        LOG.debug(" ----------- start class file  duplicate check   -----------");
        String configPath = DEFAULT_PATH;
        VersionCheck.checkDuplicate(Logger.class);
        VersionCheck.checkDuplicate(Preconditions.class);
        VersionCheck.checkDuplicate(ApplicationContext.class);
        VersionCheck.checkDuplicate(BeanInfoFactory.class);
        VersionCheck.checkDuplicate("org.junit.Assume.class");
        VersionCheck.checkDuplicate(DEFAULT_PATH);
        VersionCheck.checkDuplicate(DEFAULT_PATH);
        LOG.debug(" ----------- end class file  duplicate check   -----------");
        LOG.debug(" ----------- start init config  -----------");
        int threshold = 500;
        InputStream propertiesInputStream = InitOperation.class.getResourceAsStream(DEFAULT_PATH);
        if (propertiesInputStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(propertiesInputStream);
                String thresholdStr = properties.getProperty("timeprofile.threshold");
                if (NumberUtils.isNumber((String)thresholdStr)) {
                    threshold = Integer.valueOf(thresholdStr);
                }
            }
            catch (Exception e) {
                LOG.error(" ----------- init time profile  error !  -----------" + EnvInfo.getEnvInfo(), (Throwable)e);
            }
            finally {
                try {
                    propertiesInputStream.close();
                }
                catch (IOException iOException) {}
                LOG.info("threshold info {}", (Object)threshold);
            }
        }
        DBTimeProfile.setThreshold(threshold);
        LOG.debug(" ----------- end of  init   config  -----------");
        initialized = true;
    }
}

