package cn.com.duiba.tuia.pangea.center.api.constant;


/**
 *  @author: xuesong
 *  @Date: 2020-01-06 15:01
 *  @Description: 数据查询排序
 */
public enum SpreadDataOrderByEnum {

    act_request_pv(1, "活动请求pv", "sum(act_request_pv)"),
    act_request_uv(2, "活动请求uv", "sum(act_request_uv)"),
    act_join_pv(3, "活动参与pv", "sum(act_join_pv)"),
    act_join_uv(4, "活动请求uv", "sum(act_join_uv)"),
    advert_request_pv(5, "券请求", "sum(advert_request_pv)"),
    advert_request_count(6, "发券量", "sum(advert_request_count)"),
    advert_show_count(7, "券曝光", "sum(advert_show_count)"),
    advert_click_count(8, "券有效点击", "sum(advert_click_count)"),
    ad_inter_consume(9, "互动消耗", "sum(ad_inter_consume)"),
    ad_add_consume(10, "增值消耗", "sum(ad_add_consume)"),
    ad_consume(11, "消耗", "sum(ad_consume)"),
    form_fee_click(12, "表单类计费点击", "sum(form_fee_click)"),
    form_land_pv(13, "表单类落地页访问", "sum(form_land_pv)"),
    form_land_inner_pv(14, "表单类落地页转化", "sum(form_land_inner_pv)"),
    land_change_pv(15, "落地页转化", "sum(land_change_pv)"),

    join_rate(16, "参与率", "sum(act_join_uv)/sum(act_request_pv)"),
    re_join_rate(17, "复参率", "sum(act_join_pv)/sum(act_request_pv)"),
    advert_request_rate(18, "发券成功率", "sum(advert_request_count)/sum(advert_request_pv)"),
    advert_show_rate(19, "发券成功率", "sum(advert_show_count)/sum(advert_show_count)"),
    ctr(20, "ctr", "sum(advert_click_count)/sum(advert_show_count)"),
    uv_join_rate(21, "每uv参与", "sum(act_join_pv)/sum(act_request_uv)"),
    uv_send_rate(22, "每uv发券", "sum(advert_request_count)/sum(act_request_uv)"),
    uv_click_rate(23, "每uv券点击", "sum(advert_click_count)/sum(act_request_uv)"),
    uv_consume(24, "每UV收益", "sum(ad_consume)/sum(act_request_uv)"),
    form_cvr(25, "表单类广告CVR", "sum(form_land_inner_pv)/sum(form_fee_click)"),
    cvr(26, "cvr", "sum(land_change_pv)/sum(advert_click_count)"),
    uv_con_m_cvr(27, "每UV收益*cvr", "sum(ad_consume)/sum(act_request_uv)*(sum(land_change_pv)/sum(advert_click_count))");

    private Integer type;

    private String desc;

    private String code;


    SpreadDataOrderByEnum(Integer type, String desc, String code) {
        this.type = type;
        this.desc = desc;
        this.code = code;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    public static String getCode(int type) {
        for (SpreadDataOrderByEnum value : SpreadDataOrderByEnum.values()) {
            if (type == value.type) {
                return value.code;
            }
        }
        return null;
    }

}
