/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.Header;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.VendorExtension;

public class ResponseMessageBuilder {
    private int code;
    private String message;
    private ModelReference responseModel;
    private Map<String, Header> headers = Maps.newTreeMap();
    private List<VendorExtension> vendorExtensions = Lists.newArrayList();

    public ResponseMessageBuilder code(int code) {
        this.code = code;
        return this;
    }

    public ResponseMessageBuilder message(String message) {
        this.message = BuilderDefaults.defaultIfAbsent(message, this.message);
        return this;
    }

    public ResponseMessageBuilder responseModel(ModelReference responseModel) {
        this.responseModel = BuilderDefaults.defaultIfAbsent(responseModel, this.responseModel);
        return this;
    }

    @Deprecated
    public ResponseMessageBuilder headers(Map<String, ModelReference> headers) {
        this.headers.putAll(Maps.transformEntries(BuilderDefaults.nullToEmptyMap(headers), this.toHeaderEntry()));
        return this;
    }

    private Maps.EntryTransformer<String, ModelReference, Header> toHeaderEntry() {
        return new Maps.EntryTransformer<String, ModelReference, Header>(){

            public Header transformEntry(String key, ModelReference value) {
                return new Header(key, "", value);
            }
        };
    }

    public ResponseMessageBuilder headersWithDescription(Map<String, Header> headers) {
        this.headers.putAll(BuilderDefaults.nullToEmptyMap(headers));
        return this;
    }

    public ResponseMessageBuilder vendorExtensions(List<VendorExtension> extensions) {
        this.vendorExtensions.addAll(BuilderDefaults.nullToEmptyList(extensions));
        return this;
    }

    public ResponseMessage build() {
        return new ResponseMessage(this.code, this.message, this.responseModel, this.headers, this.vendorExtensions);
    }
}

