package cn.com.duiba.tuia.pangea.center.api.dto.apollo;

import java.io.Serializable;
import java.util.Date;

/**
 * 阿波罗盘古key-value
 *
 * @author wangzhanjin
 * @email
 * @date 2020-07-21 14:46:33
 */
public class ApolloKeyValueHistoryDTO implements Serializable {
    private static final long serialVersionUID = -187285892655751311L;

    private Long id;
    /**
     * key的主键id
     */
    private Long keyId;
    /**
     * 0为专项定制，其他需要列表处理json校验：1为媒体，2为广告位，3为活动，4皮肤，5广告（待定）
     */
    private String keyType;
    /**
     * 配置key名称
     */
    private String keyName;
    /**
     * 配置的描述，使用方法
     */
    private String keyDesc;
    /**
     * 配置的cf链接
     */
    private String keyCfUrl;
    /**
     * 配置key的关键字，唯一
     */
    private String keyStr;
    /**
     * 配置key对应的value值，type>0都是json
     */
    private String keyValueJson;
    /**
     * 当前配置的开关，默认1开，0关
     */
    private Integer keyOnOff;
    /**
     * 默认1，白名单1，黑名单2
     */
    private Integer whiteBlack;
    /**
     * 当前创建人的信息
     */
    private String admin;
    /**
     * 下线时间，待定
     */
    private Date offlineTime;
    /**
     *
     */
    private Date gmtCreate;
    /**
     * 修改时间，强删表，有历史表
     */
    private Date gmtModified;

    /**
     * 设置：
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取：
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置：key的主键id
     */
    public void setKeyId(Long keyId) {
        this.keyId = keyId;
    }

    /**
     * 获取：key的主键id
     */
    public Long getKeyId() {
        return keyId;
    }

    /**
     * 设置：0为专项定制，其他需要列表处理json校验：1为媒体，2为广告位，3为活动，4皮肤，5广告（待定）
     */
    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    /**
     * 获取：0为专项定制，其他需要列表处理json校验：1为媒体，2为广告位，3为活动，4皮肤，5广告（待定）
     */
    public String getKeyType() {
        return keyType;
    }

    /**
     * 设置：配置key名称
     */
    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    /**
     * 获取：配置key名称
     */
    public String getKeyName() {
        return keyName;
    }

    /**
     * 设置：配置的描述，使用方法
     */
    public void setKeyDesc(String keyDesc) {
        this.keyDesc = keyDesc;
    }

    /**
     * 获取：配置的描述，使用方法
     */
    public String getKeyDesc() {
        return keyDesc;
    }

    /**
     * 设置：配置的cf链接
     */
    public void setKeyCfUrl(String keyCfUrl) {
        this.keyCfUrl = keyCfUrl;
    }

    /**
     * 获取：配置的cf链接
     */
    public String getKeyCfUrl() {
        return keyCfUrl;
    }

    /**
     * 设置：配置key的关键字，唯一
     */
    public void setKeyStr(String keyStr) {
        this.keyStr = keyStr;
    }

    /**
     * 获取：配置key的关键字，唯一
     */
    public String getKeyStr() {
        return keyStr;
    }

    /**
     * 设置：配置key对应的value值，type>0都是json
     */
    public void setKeyValueJson(String keyValueJson) {
        this.keyValueJson = keyValueJson;
    }

    /**
     * 获取：配置key对应的value值，type>0都是json
     */
    public String getKeyValueJson() {
        return keyValueJson;
    }

    /**
     * 设置：当前配置的开关，默认1开，0关
     */
    public void setKeyOnOff(Integer keyOnOff) {
        this.keyOnOff = keyOnOff;
    }

    /**
     * 获取：当前配置的开关，默认1开，0关
     */
    public Integer getKeyOnOff() {
        return keyOnOff;
    }

    /**
     * 设置：默认1，白名单1，黑名单2
     */
    public void setWhiteBlack(Integer whiteBlack) {
        this.whiteBlack = whiteBlack;
    }

    /**
     * 获取：默认1，白名单1，黑名单2
     */
    public Integer getWhiteBlack() {
        return whiteBlack;
    }

    /**
     * 设置：当前创建人的信息
     */
    public void setAdmin(String admin) {
        this.admin = admin;
    }

    /**
     * 获取：当前创建人的信息
     */
    public String getAdmin() {
        return admin;
    }

    /**
     * 设置：下线时间，待定
     */
    public void setOfflineTime(Date offlineTime) {
        this.offlineTime = offlineTime;
    }

    /**
     * 获取：下线时间，待定
     */
    public Date getOfflineTime() {
        return offlineTime;
    }

    /**
     * 设置：
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取：
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置：修改时间，强删表，有历史表
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * 获取：修改时间，强删表，有历史表
     */
    public Date getGmtModified() {
        return gmtModified;
    }
}
