package cn.com.duiba.tuia.pangea.center.api.remoteservice;

/**
 * @author yuantong
 * @version 1.0  接口提供给activity-web使用
 * @since 2019-10-30 16:02
 */

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.dto.PgPlanInfo;
import cn.com.duiba.tuia.pangea.center.api.dto.resource.TestResourceFlowDTO;
import cn.com.duiba.tuia.pangea.center.api.req.activityweb.PgTestResourceRatioReq;
import cn.com.duiba.tuia.pangea.center.api.req.activityweb.PgTestResourceReq;
import cn.com.duiba.tuia.pangea.center.api.rsp.activityweb.PgTestResourceRsp;

import java.util.List;

@AdvancedFeignClient
public interface RemotePgResourceAcWebService {


    /**
     * 根据条件查询 资源位的 比例的结果 然后走盘古还是大盘
     * @param req
     * @return
     */
    Integer getResourceRatio(PgTestResourceRatioReq req);


    /**
     * 根据条件查询 资源位的 结果
     * @param pgTestResourceReq
     * @return
     */
    PgTestResourceRsp getTestResourceResult(PgTestResourceReq pgTestResourceReq);

    /**
     * 根据测试计划id和slotId、activityId 分组序号查询 测试组配置
     * @param planId
     * @param slotId
     * @param activityId
     * @param groupTag
     * @return
     */
    TestResourceFlowDTO getTestResourceConfig(Long planId, Long slotId, Long activityId, Integer groupTag);

    /**
     * 获取广告位的所有在测的资源位的盘古测试计划
     * @param slotId
     * @return
     */
    List<PgPlanInfo> listSlotResourcePlan(Long slotId);

}
