package cn.com.duiba.tuia.pangea.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.dto.ActivityDto;
import cn.com.duiba.tuia.pangea.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.pangea.center.api.dto.PlanDto;
import cn.com.duiba.tuia.pangea.center.api.dto.data.TestResultDTO;
import cn.com.duiba.tuia.pangea.center.api.dto.openweb.PgPlanActivityDto;
import cn.com.duiba.tuia.pangea.center.api.req.*;
import cn.com.duiba.tuia.pangea.center.api.req.openweb.PgPlanSlotRatioReq;
import cn.com.duiba.tuia.pangea.center.api.rsp.TestResultRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.plan.SlotIdToContrastRsp;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * 测试计划
 */
@AdvancedFeignClient
public interface RemotePlanService {


    PageResultDto<PlanDto> pages(PlanQueryReq req);

    DubboResult<Map<String, Object>> next(PlanInsertReq req);

    DubboResult<Long> addPlan(PlanInsertReq req);

    DubboResult<Boolean> checkExistActivity(List<Long> list);

    PlanDto selectById(Long id);

    DubboResult<Integer> updatePlan(PlanUpdateReq req);

    List<ActivityDto> findByActivityIds(List<Long> activityIds);

    DubboResult<Boolean> modifyPlanStatus(Long id, Integer planStatus);

    Map<String, Object> getSlotDataByActivityIds(List<Long> activityIds);

    /**
     * 查询测试计划的里面的对照组 测试组活动
     * @param ratioReq
     * @return 测试计划的里面的对照组 测试组活动
     */
    List<PgPlanActivityDto> getPlanInfoByPgReq(PgPlanSlotRatioReq ratioReq);

    List<SlotIdToContrastRsp> getSlotIdToContrast(SlotUvQueryReq req);

    Long getPlanTotalGroupTest(PlanGroupListReq req);

    Map<String, Object> getSlotDataByActivityIdsAndTestType(List<Long> activityIds, Integer testType);
    /**
     * 全部活动的全部切量数据
     * @return
     */
    Map<String, Object> getSlotDataByAllActivity();

    /**
     * 基础信息→资源位/响应式插件/弹层测试类型 的下一步接口
     * @param req
     * @return
     */
    DubboResult<Map<String, Object>> resourceNext(PlanInsertReq req);

//    List<ActivityDto> findAllActivitys(List<Long> activityIds);

    /**
     * 更新 测试计划状态从未完成到未开始
     * @param planId
     * @param testAddMore 是否追加投放操作，1：是，null或0：不是
     * @return
     */
    Boolean completePlan(Long planId, Integer testAddMore);

    /**
     * 根据请求参数获取 点击全部切量的数据
     * @param req
     * @return
     */
    Map<String, Object> getSlotDataByReq(SlotUvQueryReq req);

    /**
     * 列出 近三天所有可测试的 活动id
     * @param req
     * @return
     */
    List<Long> listCanTestActivityIds(SlotUvQueryReq req);


    /**
     *  测试结论详情
     */
    TestResultDTO getTestResultDetail(TestResultRsp rsp);

    /**
     *  删除未完成测试计划
     */
    Boolean deleteById(Long id);
}

