package cn.com.duiba.tuia.pangea.center.api.req.flowmanager;

import cn.com.duiba.tuia.pangea.center.api.dto.BaseQueryDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author yuantong
 * @version 1.0
 * @since 2019-09-06 13:15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ReqFlowBaseByPageDto extends BaseQueryDto implements Serializable {


    private static final long serialVersionUID = 91777783199865422L;

    private Long planId;
    /**
     * 媒体ID.
     */
    private Long appId;

    private Long slotId;

    private Long regionId;

    private Byte blackDeleted;

    /**
     * 黑名单列表
     */
    private List<Long> shieldSlotIds;

    /**
     * 数据显示开始时间
     */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String startTime;

    /**
     * 数据显示关闭时间
     */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String endTime;

    /**
     * 操作人id
     */
    private Long adminId;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}