/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu;

import cn.com.duiba.tuia.pangea.center.api.dto.apollo.ApolloKeyValueDTO;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.pangea.center.api.remoteservice.RemoteApolloKeyValueService;
import cn.com.duiba.tuia.pangea.center.api.utils.HashAlgorithm;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApolloPanGuServiceImpl
implements ApolloPanGuService {
    private static final Logger log = LoggerFactory.getLogger(ApolloPanGuServiceImpl.class);
    @Resource
    private RemoteApolloKeyValueService remoteApolloKeyValueService;
    @Resource
    private ExecutorService executorService;
    private CacheLoader<String, String> APOLLO_STRING_LOADER = new CacheLoader<String, String>(){

        public String load(String keyStr) {
            if (StringUtils.isEmpty((String)keyStr)) {
                return "";
            }
            String keyIdMapStr = ApolloPanGuServiceImpl.this.getKeyIdMapStr(keyStr);
            log.info("APOLLO_STRING_LOADER\u7f13\u5b58\u67e5\u8be2\uff0ckeyStr\uff0c{}\uff0ckeyIdMapStr\uff0c{}", (Object)keyStr, (Object)keyIdMapStr);
            return keyIdMapStr;
        }

        public ListenableFuture<String> reload(String keyStr, String oldValue) {
            ListenableFutureTask task = ListenableFutureTask.create(() -> this.load(keyStr));
            ApolloPanGuServiceImpl.this.executorService.submit((Runnable)task);
            return task;
        }
    };
    private LoadingCache<String, String> APOLLO_PANGU_STRING_CACHE = CacheBuilder.newBuilder().initialCapacity(1024).concurrencyLevel(20).refreshAfterWrite(1L, TimeUnit.SECONDS).expireAfterWrite(20L, TimeUnit.HOURS).build(this.APOLLO_STRING_LOADER);
    private CacheLoader<String, Map<String, String>> APOLLO_MAP_LOADER = new CacheLoader<String, Map<String, String>>(){

        public Map<String, String> load(@NotNull String keyStr) {
            return ApolloPanGuServiceImpl.this.getStringMapFromRPC(keyStr);
        }

        public ListenableFuture<Map<String, String>> reload(String keyStr, Map<String, String> oldValue) {
            ListenableFutureTask task = ListenableFutureTask.create(() -> this.load(keyStr));
            ApolloPanGuServiceImpl.this.executorService.submit((Runnable)task);
            return task;
        }
    };
    private LoadingCache<String, Map<String, String>> APOLLO_PANGU_MAP_CACHE = CacheBuilder.newBuilder().initialCapacity(1024).concurrencyLevel(20).refreshAfterWrite(1L, TimeUnit.SECONDS).expireAfterWrite(20L, TimeUnit.HOURS).build(this.APOLLO_MAP_LOADER);

    @Override
    public String getIdMapStrByKeyStr(String keyStr) {
        return (String)this.APOLLO_PANGU_STRING_CACHE.getUnchecked((Object)keyStr);
    }

    @Override
    public String getIdMapStrByKeyStrResourceId(String keyStr, String resourceId) {
        Map map = (Map)this.APOLLO_PANGU_MAP_CACHE.getUnchecked((Object)keyStr);
        if (MapUtils.isEmpty((Map)map)) {
            return null;
        }
        return (String)map.get(resourceId);
    }

    @Override
    public Boolean getIdMapStrIsOne(String keyStr) {
        String unchecked = (String)this.APOLLO_PANGU_STRING_CACHE.getUnchecked((Object)keyStr);
        if (StringUtils.isEmpty((String)unchecked)) {
            return null;
        }
        boolean flag = unchecked.equals("1");
        log.info("Apollo\u76d8\u53e4\u914d\u7f6e\uff0cgetIdMapStrIsOne,{}\uff0cboolean\uff0c{}", (Object)keyStr, (Object)flag);
        return flag;
    }

    @Override
    public Boolean getIdMapStrListShuntFlag(String keyStr, String resourceId, String deviceId) {
        String valueFromApollo = this.getIdMapStrByKeyStrResourceId(keyStr, resourceId);
        if (StringUtils.isEmpty((String)valueFromApollo) || !NumberUtils.isNumeric((String)valueFromApollo)) {
            log.error("Apollo\u76d8\u53e4\u914d\u7f6e\uff0c\u6b63\u4ea4\u5206\u6d41\u8fd4\u56de\u975e\u6570\u5b57,{}", (Object)valueFromApollo);
            return false;
        }
        int ratio = Integer.valueOf(valueFromApollo);
        if (ratio >= 100) {
            return true;
        }
        int hash = HashAlgorithm.dekHash(deviceId + keyStr);
        int value = (hash < 0 ? -hash : hash) % 100;
        boolean flag = value >= 0 && value < ratio;
        log.info("Apollo\u76d8\u53e4\u914d\u7f6e\uff0c\u6b63\u4ea4\u5206\u6d41 getIdMapStrListShuntFlag\uff0ckeyStr{},ResourceId{},DeviceId\uff1a{}\uff0cflag\uff1a{}", new Object[]{keyStr, resourceId, deviceId, flag});
        return flag;
    }

    private Map<String, String> getStringMapFromRPC(String keyStr) {
        HashMap<String, String> keyIdMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)keyStr)) {
            return keyIdMap;
        }
        String keyIdMapStr = this.getKeyIdMapStr(keyStr);
        if (StringUtils.isEmpty((String)keyIdMapStr)) {
            log.error("getStringMapFromRPC \u67e5\u8be2\u4e3a\u7a7a\uff0ckeyStr\uff0c{}", (Object)keyStr);
            return keyIdMap;
        }
        log.info("getStringMapFromRPC \u67e5\u8be2\u7ed3\u679cOK\uff0ckeyStr\uff0c{}\uff0ckeyIdMapStr\uff0c{}", (Object)keyStr, (Object)keyIdMapStr);
        try {
            Map keyIdMapTemp = (Map)JSON.parse((String)keyIdMapStr);
            for (Object key : keyIdMapTemp.keySet()) {
                keyIdMap.put(key + "", keyIdMapTemp.get(key) + "");
            }
        }
        catch (Exception e) {
            log.error("getStringMapFromRPC \u7f13\u5b58\u8f6c\u6362\u5931\u8d25", (Throwable)e);
        }
        return keyIdMap;
    }

    private String getKeyIdMapStr(String keyStr) {
        ApolloKeyValueDTO apolloKeyValueDTO = new ApolloKeyValueDTO();
        apolloKeyValueDTO.setKeyStr(keyStr);
        apolloKeyValueDTO.setKeyOnOff(1);
        apolloKeyValueDTO = this.remoteApolloKeyValueService.selectApolloKeyValue(apolloKeyValueDTO);
        return null == apolloKeyValueDTO ? "" : apolloKeyValueDTO.getKeyIdMapStr();
    }
}

