package cn.com.duiba.tuia.pangea.center.api.utils;

import cn.com.duiba.tuia.pangea.center.api.constant.PlanActivityTypeEnum;
import cn.com.duiba.tuia.pangea.center.api.rsp.DayAppReportRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.DayReportRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.DayReportRspList;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author scd
 * @version 1.0
 * @since 2019-09-06 18:06
 */
public class DataUtils {

    /**
     * 封装媒体列表数据
     * @param result
     * @param test
     * @param duizhao
     * @return
     */
    public static DayAppReportRsp buildAppData(DayAppReportRsp result, List<DayReportRsp> test,
            List<DayReportRsp> duizhao) {
        //封装对照组数据
        if (CollectionUtils.isNotEmpty(duizhao)) {
            for (int i = 0; i < duizhao.size(); i++) {
                DayReportRsp duizhaoDo = duizhao.get(i);
                result.setAppId(duizhaoDo.getAppId());
                result.setAppName(duizhaoDo.getAppName());
                result.setSlotId(duizhaoDo.getSlotId());
                result.setSlotName(duizhaoDo.getSlotName());
                result.setCurDateString(duizhaoDo.getCurDateString());
                result.setDuizhao_activityType(PlanActivityTypeEnum.DUIZHAO.getCode());
                result.setDuizhao_activityId(duizhaoDo.getActivityId());
                result.setDuizhao_activityStatus(duizhaoDo.getActivityStatus());

                result.setDuizhao_actRequestPv(
                        duizhaoDo.getActRequestPv() + result.getDuizhao_actRequestPv());
                result.setDuizhao_actRequestUv(
                        duizhaoDo.getActRequestUv() + result.getDuizhao_actRequestUv());
                result.setDuizhao_actJoinUv(
                        duizhaoDo.getActJoinUv() + result.getDuizhao_actJoinUv());
                result.setDuizhao_actJoinPv(
                        duizhaoDo.getActJoinPv() + result.getDuizhao_actJoinPv());
                result.setDuizhao_advertRequestPv(
                        duizhaoDo.getAdvertRequestPv() + result.getDuizhao_advertRequestPv());
                result.setDuizhao_advertRequestCount(
                        duizhaoDo.getAdvertRequestCount() + result.getDuizhao_advertRequestCount());
                result.setDuizhao_advertShowCount(
                        duizhaoDo.getAdvertShowCount() + result.getDuizhao_advertShowCount());
                result.setDuizhao_advertClickCount(
                        duizhaoDo.getAdvertClickCount() + result.getDuizhao_advertClickCount());
                result.setDuizhao_adConsume(
                        duizhaoDo.getAdConsume() + result.getDuizhao_adConsume());
                result.setDuizhao_adConsume_export(
                        calculateClickRate(result.getDuizhao_adConsume(), 10000L));
                result.setDuizhao_formFeeClick(
                        duizhaoDo.getFormFeeClick() + result.getDuizhao_formFeeClick());
                result.setDuizhao_formLandPv(
                        duizhaoDo.getFormLandPv() + result.getDuizhao_formLandPv());
                result.setDuizhao_formLandInnerPv(
                        duizhaoDo.getFormLandInnerPv() + result.getDuizhao_formLandInnerPv());

                result.setDuizhao_actParticipateRate(duizhaoDo.getActParticipateRate());
                result.setDuizhao_rptParticipateCount(duizhaoDo.getRptParticipateCount());
                result.setDuizhao_advertSuccessRate(duizhaoDo.getAdvertSuccessRate());
                result.setDuizhao_requestSuccessRate(duizhaoDo.getRequestSuccessRate());
                result.setDuizhao_actPerUvClickCount(duizhaoDo.getActPerUvClickCount());
                result.setDuizhao_actPerUvLaunchCount(duizhaoDo.getActPerUvLaunchCount());
                result.setDuizhao_actPerUvClickLaunchCount(duizhaoDo.getActPerUvClickLaunchCount());

                result.setDuizhao_actPerUvConsume(duizhaoDo.getActPerUvConsume());
                /*if(result.getDuizhao_actPerUvConsume() != null){
                    Float resultdd = result.getDuizhao_actPerUvConsume();
                    result.setDuizhao_actPerUvConsume(calculateClickRate100(resultdd));
                }*/
                result.setDuizhao_formAdvertCvr(duizhaoDo.getFormAdvertCvr());
                result.setDuizhao_ctr(duizhaoDo.getCtr());
                result.setDuizhao_cvr(duizhaoDo.getCvr());
            }
        }

        if (CollectionUtils.isNotEmpty(test)) {
            result.setTestCount(test.size());
            for (int i = 0; i < test.size(); i++) {
                DayReportRsp testDo = test.get(i);
                if (i == 0) {
                    result.setAppId(testDo.getAppId());
                    result.setAppName(testDo.getAppName());
                    result.setSlotId(testDo.getSlotId());
                    result.setSlotName(testDo.getSlotName());
                    result.setCurDateString(testDo.getCurDateString());
                    result.setTest1_activitySource(testDo.getActivitySource());
                    result.setTest1_activityType(PlanActivityTypeEnum.TEST.getCode());
                    result.setTest1_activityId(testDo.getActivityId());
                    result.setTest1_activityStatus(testDo.getActivityStatus());
                    result.setTest1_actRequestPv(testDo.getActRequestPv());
                    result.setTest1_actRequestUv(testDo.getActRequestUv());
                    result.setTest1_actJoinUv(testDo.getActJoinUv());
                    result.setTest1_actJoinPv(testDo.getActJoinPv());
                    result.setTest1_advertRequestPv(testDo.getAdvertRequestPv());
                    result.setTest1_advertRequestCount(testDo.getAdvertRequestCount());
                    result.setTest1_advertShowCount(testDo.getAdvertShowCount());
                    result.setTest1_advertClickCount(testDo.getAdvertClickCount());
                    result.setTest1_adConsume(testDo.getAdConsume());
                    result.setTest1_adConsume_export(
                            calculateClickRate(result.getTest1_adConsume(), 10000L));
                    result.setTest1_formFeeClick(testDo.getFormFeeClick());
                    result.setTest1_formLandPv(testDo.getFormLandPv());
                    result.setTest1_formLandInnerPv(testDo.getFormLandInnerPv());
                    result.setTest1_actParticipateRate(testDo.getActParticipateRate());
                    result.setTest1_rptParticipateCount(testDo.getRptParticipateCount());
                    result.setTest1_advertSuccessRate(testDo.getAdvertSuccessRate());
                    result.setTest1_requestSuccessRate(testDo.getRequestSuccessRate());
                    result.setTest1_actPerUvClickCount(testDo.getActPerUvClickCount());
                    result.setTest1_actPerUvLaunchCount(testDo.getActPerUvLaunchCount());
                    result.setTest1_actPerUvClickLaunchCount(testDo.getActPerUvClickLaunchCount());
                    result.setTest1_actPerUvConsume(testDo.getActPerUvConsume());
                  /*  if(result.getTest1_actPerUvConsume() != null){
                        Float sds =result.getTest1_actPerUvConsume();
                        result.setTest1_actPerUvConsume(calculateClickRate100(sds));

                    }*/
                    result.setTest1_formAdvertCvr(testDo.getFormAdvertCvr());
                    result.setTest1_ctr(testDo.getCtr());
                    result.setTest1_cvr(testDo.getCvr());
                    result.setTest1_showButton(testDo.getShowButton());
                } else if (i == 1) {
                    result.setAppId(testDo.getAppId());
                    result.setAppName(testDo.getAppName());
                    result.setSlotId(testDo.getSlotId());
                    result.setSlotName(testDo.getSlotName());
                    result.setCurDateString(testDo.getCurDateString());
                    result.setTest2_activitySource(testDo.getActivitySource());
                    result.setTest2_activityType(PlanActivityTypeEnum.TEST.getCode());
                    result.setTest2_activityId(testDo.getActivityId());
                    result.setTest2_activityStatus(testDo.getActivityStatus());
                    result.setTest2_actRequestPv(testDo.getActRequestPv());
                    result.setTest2_actRequestUv(testDo.getActRequestUv());
                    result.setTest2_actJoinUv(testDo.getActJoinUv());
                    result.setTest2_actJoinPv(testDo.getActJoinPv());
                    result.setTest2_advertRequestPv(testDo.getAdvertRequestPv());
                    result.setTest2_advertRequestCount(testDo.getAdvertRequestCount());
                    result.setTest2_advertShowCount(testDo.getAdvertShowCount());
                    result.setTest2_advertClickCount(testDo.getAdvertClickCount());
                    result.setTest2_adConsume(testDo.getAdConsume());
                    result.setTest2_adConsume_export(
                            calculateClickRate(result.getTest2_adConsume(), 10000L));
                    result.setTest2_formFeeClick(testDo.getFormFeeClick());
                    result.setTest2_formLandPv(testDo.getFormLandPv());
                    result.setTest2_formLandInnerPv(testDo.getFormLandInnerPv());
                    result.setTest2_actParticipateRate(testDo.getActParticipateRate());
                    result.setTest2_rptParticipateCount(testDo.getRptParticipateCount());
                    result.setTest2_advertSuccessRate(testDo.getAdvertSuccessRate());
                    result.setTest2_requestSuccessRate(testDo.getRequestSuccessRate());
                    result.setTest2_actPerUvClickCount(testDo.getActPerUvClickCount());
                    result.setTest2_actPerUvLaunchCount(testDo.getActPerUvLaunchCount());
                    result.setTest2_actPerUvClickLaunchCount(testDo.getActPerUvClickLaunchCount());
                    result.setTest2_actPerUvConsume(testDo.getActPerUvConsume());
                 /*   if(result.getTest2_actPerUvConsume() != null){
                        Float sds =result.getTest2_actPerUvConsume();
                        result.setTest2_actPerUvConsume(calculateClickRate100(sds));
                    }*/
                    result.setTest2_formAdvertCvr(testDo.getFormAdvertCvr());
                    result.setTest2_ctr(testDo.getCtr());
                    result.setTest2_cvr(testDo.getCvr());
                    result.setTest2_showButton(testDo.getShowButton());
                } else if (i == 2) {

                    result.setAppId(testDo.getAppId());
                    result.setAppName(testDo.getAppName());
                    result.setSlotId(testDo.getSlotId());
                    result.setSlotName(testDo.getSlotName());
                    result.setCurDateString(testDo.getCurDateString());
                    result.setTest3_activitySource(testDo.getActivitySource());
                    result.setTest3_activityType(PlanActivityTypeEnum.TEST.getCode());
                    result.setTest3_activityId(testDo.getActivityId());
                    result.setTest3_activityStatus(testDo.getActivityStatus());
                    result.setTest3_actRequestPv(testDo.getActRequestPv());
                    result.setTest3_actRequestUv(testDo.getActRequestUv());
                    result.setTest3_actJoinUv(testDo.getActJoinUv());
                    result.setTest3_actJoinPv(testDo.getActJoinPv());
                    result.setTest3_advertRequestPv(testDo.getAdvertRequestPv());
                    result.setTest3_advertRequestCount(testDo.getAdvertRequestCount());
                    result.setTest3_advertShowCount(testDo.getAdvertShowCount());
                    result.setTest3_advertClickCount(testDo.getAdvertClickCount());
                    result.setTest3_adConsume(testDo.getAdConsume());
                    result.setTest3_adConsume_export(
                            calculateClickRate(result.getTest3_adConsume(), 10000L));
                    result.setTest3_formFeeClick(testDo.getFormFeeClick());
                    result.setTest3_formLandPv(testDo.getFormLandPv());
                    result.setTest3_formLandInnerPv(testDo.getFormLandInnerPv());
                    result.setTest3_actParticipateRate(testDo.getActParticipateRate());
                    result.setTest3_rptParticipateCount(testDo.getRptParticipateCount());
                    result.setTest3_advertSuccessRate(testDo.getAdvertSuccessRate());
                    result.setTest3_requestSuccessRate(testDo.getRequestSuccessRate());
                    result.setTest3_actPerUvClickCount(testDo.getActPerUvClickCount());
                    result.setTest3_actPerUvLaunchCount(testDo.getActPerUvLaunchCount());
                    result.setTest3_actPerUvClickLaunchCount(testDo.getActPerUvClickLaunchCount());

                    result.setTest3_actPerUvConsume(testDo.getActPerUvConsume());
                  /*  if(result.getTest3_actPerUvConsume() != null){
                        Float sds =result.getTest3_actPerUvConsume();
                        result.setTest3_actPerUvConsume(calculateClickRate100(sds));
                    }*/
                    result.setTest3_formAdvertCvr(testDo.getFormAdvertCvr());
                    result.setTest3_ctr(testDo.getCtr());
                    result.setTest3_cvr(testDo.getCvr());
                    result.setTest3_showButton(testDo.getShowButton());
                }
            }
        }
        return result;
    }



    public static DayAppReportRsp fillAppData(DayReportRsp duizhaoDo, List<DayReportRsp> test){
        DayAppReportRsp result = new DayAppReportRsp();

        result.setAppId(duizhaoDo.getAppId());
        result.setAppName(duizhaoDo.getAppName());
        result.setSlotId(duizhaoDo.getSlotId());
        result.setSlotName(duizhaoDo.getSlotName());
        result.setCurDateString(duizhaoDo.getCurDateString());
        result.setDuizhao_activityType(PlanActivityTypeEnum.DUIZHAO.getCode());
        result.setDuizhao_activityId(duizhaoDo.getActivityId());
        result.setDuizhao_activityStatus(duizhaoDo.getActivityStatus());

        result.setDuizhao_actRequestPv(duizhaoDo.getActRequestPv());
        result.setDuizhao_actRequestUv(duizhaoDo.getActRequestUv());
        result.setDuizhao_actJoinUv(duizhaoDo.getActJoinUv());
        result.setDuizhao_actJoinPv(duizhaoDo.getActJoinPv());
        result.setDuizhao_advertRequestPv(duizhaoDo.getAdvertRequestPv());
        result.setDuizhao_advertRequestCount(duizhaoDo.getAdvertRequestCount());
        result.setDuizhao_advertShowCount(duizhaoDo.getAdvertShowCount());
        result.setDuizhao_advertClickCount(duizhaoDo.getAdvertClickCount());
        result.setDuizhao_adConsume(duizhaoDo.getAdConsume());
        result.setDuizhao_formFeeClick(duizhaoDo.getFormFeeClick());
        result.setDuizhao_formLandPv(duizhaoDo.getFormLandPv());
        result.setDuizhao_formLandInnerPv(duizhaoDo.getFormLandInnerPv());
        result.setDuizhao_actParticipateRate(duizhaoDo.getActParticipateRate());
        result.setDuizhao_rptParticipateCount(duizhaoDo.getRptParticipateCount());
        result.setDuizhao_advertSuccessRate(duizhaoDo.getAdvertSuccessRate());
        result.setDuizhao_requestSuccessRate(duizhaoDo.getRequestSuccessRate());
        result.setDuizhao_actPerUvClickCount(duizhaoDo.getActPerUvClickCount());
        result.setDuizhao_actPerUvLaunchCount(duizhaoDo.getActPerUvLaunchCount());
        result.setDuizhao_actPerUvClickLaunchCount(duizhaoDo.getActPerUvClickLaunchCount());
        result.setDuizhao_actPerUvConsume(duizhaoDo.getActPerUvConsume());
        result.setDuizhao_formAdvertCvr(duizhaoDo.getFormAdvertCvr());
        result.setDuizhao_ctr(duizhaoDo.getCtr());
        result.setDuizhao_cvr(duizhaoDo.getCvr());

        //封装测试组
        if(CollectionUtils.isNotEmpty(test)){
            result.setTestCount(test.size());
            for (int i = 0; i < test.size(); i++) {
                DayReportRsp testDo = test.get(i);
                if (i == 0) {
                    result.setAppId(testDo.getAppId());
                    result.setAppName(testDo.getAppName());
                    result.setSlotId(testDo.getSlotId());
                    result.setSlotName(testDo.getSlotName());
                    result.setCurDateString(testDo.getCurDateString());
                    result.setTest1_activitySource(testDo.getActivitySource());
                    result.setTest1_activityType(PlanActivityTypeEnum.TEST.getCode());
                    result.setTest1_activityId(testDo.getActivityId());
                    result.setTest1_activityStatus(testDo.getActivityStatus());
                    result.setTest1_actRequestPv(testDo.getActRequestPv());
                    result.setTest1_actRequestUv(testDo.getActRequestUv());
                    result.setTest1_actJoinUv(testDo.getActJoinUv());
                    result.setTest1_actJoinPv(testDo.getActJoinPv());
                    result.setTest1_advertRequestPv(testDo.getAdvertRequestPv());
                    result.setTest1_advertRequestCount(testDo.getAdvertRequestCount());
                    result.setTest1_advertShowCount(testDo.getAdvertShowCount());
                    result.setTest1_advertClickCount(testDo.getAdvertClickCount());
                    result.setTest1_adConsume(testDo.getAdConsume());
                    result.setTest1_adConsume_export(
                            calculateClickRate(result.getTest1_adConsume(), 10000L));
                    result.setTest1_formFeeClick(testDo.getFormFeeClick());
                    result.setTest1_formLandPv(testDo.getFormLandPv());
                    result.setTest1_formLandInnerPv(testDo.getFormLandInnerPv());
                    result.setTest1_actParticipateRate(testDo.getActParticipateRate());
                    result.setTest1_rptParticipateCount(testDo.getRptParticipateCount());
                    result.setTest1_advertSuccessRate(testDo.getAdvertSuccessRate());
                    result.setTest1_requestSuccessRate(testDo.getRequestSuccessRate());
                    result.setTest1_actPerUvClickCount(testDo.getActPerUvClickCount());
                    result.setTest1_actPerUvLaunchCount(testDo.getActPerUvLaunchCount());
                    result.setTest1_actPerUvClickLaunchCount(testDo.getActPerUvClickLaunchCount());
                    result.setTest1_actPerUvConsume(testDo.getActPerUvConsume());
                    result.setTest1_formAdvertCvr(testDo.getFormAdvertCvr());
                    result.setTest1_ctr(testDo.getCtr());
                    result.setTest1_cvr(testDo.getCvr());
                    result.setTest1_showButton(testDo.getShowButton());
                } else if (i == 1) {
                    result.setAppId(testDo.getAppId());
                    result.setAppName(testDo.getAppName());
                    result.setSlotId(testDo.getSlotId());
                    result.setSlotName(testDo.getSlotName());
                    result.setCurDateString(testDo.getCurDateString());
                    result.setTest2_activitySource(testDo.getActivitySource());
                    result.setTest2_activityType(PlanActivityTypeEnum.TEST.getCode());
                    result.setTest2_activityId(testDo.getActivityId());
                    result.setTest2_activityStatus(testDo.getActivityStatus());
                    result.setTest2_actRequestPv(testDo.getActRequestPv());
                    result.setTest2_actRequestUv(testDo.getActRequestUv());
                    result.setTest2_actJoinUv(testDo.getActJoinUv());
                    result.setTest2_actJoinPv(testDo.getActJoinPv());
                    result.setTest2_advertRequestPv(testDo.getAdvertRequestPv());
                    result.setTest2_advertRequestCount(testDo.getAdvertRequestCount());
                    result.setTest2_advertShowCount(testDo.getAdvertShowCount());
                    result.setTest2_advertClickCount(testDo.getAdvertClickCount());
                    result.setTest2_adConsume(testDo.getAdConsume());
                    result.setTest2_adConsume_export(
                            calculateClickRate(result.getTest2_adConsume(), 10000L));
                    result.setTest2_formFeeClick(testDo.getFormFeeClick());
                    result.setTest2_formLandPv(testDo.getFormLandPv());
                    result.setTest2_formLandInnerPv(testDo.getFormLandInnerPv());
                    result.setTest2_actParticipateRate(testDo.getActParticipateRate());
                    result.setTest2_rptParticipateCount(testDo.getRptParticipateCount());
                    result.setTest2_advertSuccessRate(testDo.getAdvertSuccessRate());
                    result.setTest2_requestSuccessRate(testDo.getRequestSuccessRate());
                    result.setTest2_actPerUvClickCount(testDo.getActPerUvClickCount());
                    result.setTest2_actPerUvLaunchCount(testDo.getActPerUvLaunchCount());
                    result.setTest2_actPerUvClickLaunchCount(testDo.getActPerUvClickLaunchCount());
                    result.setTest2_actPerUvConsume(testDo.getActPerUvConsume());
                    result.setTest2_formAdvertCvr(testDo.getFormAdvertCvr());
                    result.setTest2_ctr(testDo.getCtr());
                    result.setTest2_cvr(testDo.getCvr());
                    result.setTest2_showButton(testDo.getShowButton());
                } else if (i == 2) {

                    result.setAppId(testDo.getAppId());
                    result.setAppName(testDo.getAppName());
                    result.setSlotId(testDo.getSlotId());
                    result.setSlotName(testDo.getSlotName());
                    result.setCurDateString(testDo.getCurDateString());
                    result.setTest3_activitySource(testDo.getActivitySource());
                    result.setTest3_activityType(PlanActivityTypeEnum.TEST.getCode());
                    result.setTest3_activityId(testDo.getActivityId());
                    result.setTest3_activityStatus(testDo.getActivityStatus());
                    result.setTest3_actRequestPv(testDo.getActRequestPv());
                    result.setTest3_actRequestUv(testDo.getActRequestUv());
                    result.setTest3_actJoinUv(testDo.getActJoinUv());
                    result.setTest3_actJoinPv(testDo.getActJoinPv());
                    result.setTest3_advertRequestPv(testDo.getAdvertRequestPv());
                    result.setTest3_advertRequestCount(testDo.getAdvertRequestCount());
                    result.setTest3_advertShowCount(testDo.getAdvertShowCount());
                    result.setTest3_advertClickCount(testDo.getAdvertClickCount());
                    result.setTest3_adConsume(testDo.getAdConsume());
                    result.setTest3_adConsume_export(
                            calculateClickRate(result.getTest3_adConsume(), 10000L));
                    result.setTest3_formFeeClick(testDo.getFormFeeClick());
                    result.setTest3_formLandPv(testDo.getFormLandPv());
                    result.setTest3_formLandInnerPv(testDo.getFormLandInnerPv());
                    result.setTest3_actParticipateRate(testDo.getActParticipateRate());
                    result.setTest3_rptParticipateCount(testDo.getRptParticipateCount());
                    result.setTest3_advertSuccessRate(testDo.getAdvertSuccessRate());
                    result.setTest3_requestSuccessRate(testDo.getRequestSuccessRate());
                    result.setTest3_actPerUvClickCount(testDo.getActPerUvClickCount());
                    result.setTest3_actPerUvLaunchCount(testDo.getActPerUvLaunchCount());
                    result.setTest3_actPerUvClickLaunchCount(testDo.getActPerUvClickLaunchCount());

                    result.setTest3_actPerUvConsume(testDo.getActPerUvConsume());
                    result.setTest3_formAdvertCvr(testDo.getFormAdvertCvr());
                    result.setTest3_ctr(testDo.getCtr());
                    result.setTest3_cvr(testDo.getCvr());
                    result.setTest3_showButton(testDo.getShowButton());
                }
            }
        }
        return result;
    }

     /*参与率：参与UV/请求UV
    复参：参与PV/参与UV
    发券成功率：活动广告发券／活动广告券请求
    券曝光成功率：券曝光/发券量
    ctr:广告券点击／广告券曝光
    每uv参与：参与PV/请求UV
    每uv发券：发券量/请求UV
    每uv券点击：券有效点击/请求UV
    每uv收益：消耗/请求UV
    表单类广告cvr：表单类广告落地页转化pv/表单类广告券有效点击
    cvr：落地页转化pv/券有效点击*/

    /**
     * 计算各种 比例粉封封装数据
     * @param reportRsp
     * @return
     */
    @SuppressWarnings("squid:S3776")
    public static void fillActivityData(DayReportRsp reportRsp) {
        if (reportRsp != null) {
            reportRsp.setActParticipateRate(calculateClickRate(reportRsp.getActJoinUv(),
                    reportRsp.getActRequestUv())); //参与率
            reportRsp.setActParticipateRateString(
                    calculateClickRate(reportRsp.getActJoinUv(), reportRsp.getActRequestUv()) +
                            "%"); //参与率导出百分比

            reportRsp.setRptParticipateCount(
                    calculateClickRate3(reportRsp.getActJoinPv(), reportRsp.getActJoinUv()));//'复参数'
            if (reportRsp.getRptParticipateCount() != null) { //复参数除以100
                Float result = reportRsp.getRptParticipateCount();
                reportRsp.setRptParticipateCount(calculateClickRate1003(result));
            }
            reportRsp.setAdvertSuccessRate(calculateClickRate(reportRsp.getAdvertRequestCount(),
                    reportRsp.getAdvertRequestPv()));//发券成功率
            reportRsp.setAdvertSuccessRateString(
                    calculateClickRate(reportRsp.getAdvertRequestCount(),
                            reportRsp.getAdvertRequestPv()) + "%");//发券成功率

            reportRsp.setRequestSuccessRate(calculateClickRate(reportRsp.getAdvertShowCount(),
                    reportRsp.getAdvertRequestCount()));//券曝光成功率
            reportRsp.setRequestSuccessRateString(calculateClickRate(reportRsp.getAdvertShowCount(),
                    reportRsp.getAdvertRequestCount()) + "%");//券曝光成功率

            reportRsp.setActPerUvClickCount(calculateClickRate3(reportRsp.getActJoinPv(),
                    reportRsp.getActRequestUv()));//每uv参与
            if (reportRsp.getActPerUvClickCount() != null) {
                Float result = reportRsp.getActPerUvClickCount();
                reportRsp.setActPerUvClickCount(calculateClickRate1003(result));
            }
            reportRsp.setActPerUvLaunchCount(calculateClickRate3(reportRsp.getAdvertRequestCount(),
                    reportRsp.getActRequestUv()));//每uv发券
            if (reportRsp.getActPerUvLaunchCount() != null) {
                Float result = reportRsp.getActPerUvLaunchCount();
                reportRsp.setActPerUvLaunchCount(calculateClickRate1003(result));
            }

            reportRsp.setActPerUvClickLaunchCount(
                    calculateClickRate3(reportRsp.getAdvertClickCount(),
                            reportRsp.getActRequestUv()));//每uv券点击
            if (reportRsp.getActPerUvClickLaunchCount() != null) {
                Float result = reportRsp.getActPerUvClickLaunchCount();
                reportRsp.setActPerUvClickLaunchCount(calculateClickRate1003(result));
            }

            reportRsp.setActPerUvConsume(calculateClickRate3(reportRsp.getAdConsume(),
                    reportRsp.getActRequestUv()));//每uv收益
            if (reportRsp.getActPerUvConsume() != null) {
                Float result = reportRsp.getActPerUvConsume();
                reportRsp.setActPerUvConsume(calculateClickRate1003(calculateClickRate100(result)));

            }

            reportRsp.setFormAdvertCvr(calculateClickRate(reportRsp.getFormLandInnerPv(),
                    reportRsp.getFormFeeClick()));//表单类广告CvR
            if (reportRsp.getFormAdvertCvr() != null) {
                Float result = reportRsp.getFormAdvertCvr();
                reportRsp.setFormAdvertCvr(calculateClickRate100(result));
            }

            reportRsp.setCtr(calculateClickRate(reportRsp.getAdvertClickCount(),
                    reportRsp.getAdvertShowCount()));//ctr
            if (reportRsp.getCtr() != null) {
                Float result = reportRsp.getCtr();
                reportRsp.setCtr(calculateClickRate100(result));
            }

            reportRsp.setCvr(calculateClickRate3(reportRsp.getFormLandInnerPv(),
                    reportRsp.getAdvertClickCount()));
            if (reportRsp.getCvr() != null) {
                Float result = reportRsp.getCvr();
                reportRsp.setCvr(calculateClickRate1003(result));
            }
//            if (reportRsp.getActivityType() != null &&reportRsp) {
//                reportRsp.setActivityTypeString(
//                        reportRsp.getActivityType() == 2 ? PlanActivityTypeEnum.TEST
//                                .getDescription() : PlanActivityTypeEnum.DUIZHAO.getDescription());
//            } else {
//                reportRsp.setActivityTypeString("-");
//            }
            reportRsp.setAdConsumeDouble(calculateClickRate3(reportRsp.getAdConsume(), 10000L));
        }
    }

    /**
     * calculateClickRate:(计算点击率). <br/>
     *
     * @param divisor  分子
     * @param dividend 分母
     * @return the float
     * @author ZFZ
     * @since JDK 1.6
     */
    public static Float calculateClickRate(Long divisor, Long dividend) {
        Float result = 0F;
        if (dividend != null && divisor != null && divisor.longValue() != 0 &&
                dividend.longValue() != 0) {
            BigDecimal bigDivisor = new BigDecimal(divisor * 100);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, 2, BigDecimal.ROUND_HALF_UP).floatValue();
        }
        return result;
    }


    /**
     * calculateClickRate:(计算点击率). <br/>
     *
     * @param divisor  分子
     * @param dividend 分母
     * @return the float
     * @author ZFZ
     * @since JDK 1.6
     */
    public static Float calculateClickRate3(Long divisor, Long dividend) {
        Float result = 0F;
        if (dividend != null && divisor != null && divisor.longValue() != 0 &&
                dividend.longValue() != 0) {
            BigDecimal bigDivisor = new BigDecimal(divisor * 100);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, 3, BigDecimal.ROUND_HALF_UP).floatValue();
        }
        return result;
    }

    /**
     * calculateClickRate:(计算点击率). <br/>
     *
     * @param fenzi  分子
     * @return the float
     * @author ZFZ
     * @since JDK 1.6
     */
    public static Float calculateClickRate100(Float fenzi) {
        Float result = 0F;
        if (fenzi != null) {
            BigDecimal fenziBig = new BigDecimal(fenzi);
            BigDecimal fenmuBig = new BigDecimal(100F);
            return fenziBig.divide(fenmuBig, 2, BigDecimal.ROUND_HALF_UP).floatValue();
        }
        return result;
    }


    /**
     * calculateClickRate:(计算点击率). <br/>
     *
     * @param fenzi  分子
     * @return the float
     * @author ZFZ
     * @since JDK 1.6
     */
    public static Float calculateClickRate1003(Float fenzi) {
        Float result = 0F;
        if (fenzi != null) {
            BigDecimal fenziBig = new BigDecimal(fenzi);
            BigDecimal fenmuBig = new BigDecimal(100F);
            return fenziBig.divide(fenmuBig, 3, BigDecimal.ROUND_HALF_UP).floatValue();
        }
        return result;
    }



    public static void fillDapan(DayReportRspList duizhao,DayReportRsp dayReportRsp){
        duizhao.getActRequestPv().add(dayReportRsp.getActRequestPv());
        duizhao.getActRequestUv().add(dayReportRsp.getActRequestUv());
        duizhao.getActJoinUv().add(dayReportRsp.getActJoinUv());
        duizhao.getActJoinPv().add(dayReportRsp.getActJoinPv());
        duizhao.getRptParticipateCount().add(dayReportRsp.getRptParticipateCount());
        duizhao.getAdvertRequestPv().add(dayReportRsp.getAdvertRequestPv());
        duizhao.getAdvertRequestCount().add(dayReportRsp.getAdvertRequestCount());
        duizhao.getAdvertShowCount().add(dayReportRsp.getAdvertShowCount());
        duizhao.getAdvertClickCount().add(dayReportRsp.getAdvertClickCount());
        duizhao.getCtr().add(dayReportRsp.getCtr());
        duizhao.getActPerUvClickCount().add(dayReportRsp.getActPerUvClickCount());
        duizhao.getActPerUvLaunchCount().add(dayReportRsp.getActPerUvLaunchCount());
        duizhao.getActPerUvClickLaunchCount().add(dayReportRsp.getActPerUvClickLaunchCount());
        duizhao.getActPerUvConsume().add(dayReportRsp.getActPerUvConsume());
        duizhao.getFormFeeClick().add(dayReportRsp.getFormFeeClick());
        duizhao.getFormLandPv().add(dayReportRsp.getFormLandPv());
        duizhao.getFormAdvertCvr().add(dayReportRsp.getFormAdvertCvr());
        duizhao.getFormLandInnerPv().add(dayReportRsp.getFormLandInnerPv());
        duizhao.getCvr().add(dayReportRsp.getCvr());
        duizhao.getActivityId().add(dayReportRsp.getActivityId());
        duizhao.getActivityType().add(dayReportRsp.getActivityType());
        duizhao.getActivityStatus().add(dayReportRsp.getActivityStatus());
        duizhao.getActivityPrcent().add(dayReportRsp.getActivityPrcent());
        duizhao.getActParticipateRate().add(dayReportRsp.getActParticipateRate());
        duizhao.getRequestSuccessRate().add(dayReportRsp.getRequestSuccessRate());
        duizhao.getAdConsume().add(dayReportRsp.getAdConsume());
        duizhao.getActivitySource().add(dayReportRsp.getActivitySource());
    }

}
