package cn.com.duiba.tuia.pangea.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.pangea.center.api.req.ReqAppStatistics;
import cn.com.duiba.tuia.pangea.center.api.req.ReqReportByPage;
import cn.com.duiba.tuia.pangea.center.api.rsp.DayAppReportRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.DayReportRsp;
import cn.com.duiba.tuia.pangea.center.api.rsp.DayReportRspList;

import java.util.List;

/**
 * ClassName: RemoteDayReportService <br/>
 * Function: 活动测试数据相关. <br/>
 * date: 2019年9月2日 下午3:02:09 <br/>
 *
 * @author scd
 * @version
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteDayReportService {

    /**
     * 分页活动日数据列表
     * @param reqReportByPage
     * @return
     */
    List<DayReportRsp> selectDayReport(ReqReportByPage reqReportByPage);

    /**
     * 获取所有测试广告位id
     * @param req
     * @return
     */
    List<Long> getSlotIds(ReqAppStatistics req);


    /**
     * 获取分页列表
     * @param req
     * @return
     */
    PageResultDto<DayAppReportRsp> selectAppData(ReqAppStatistics req);

    /**
     * 获取分页列表
     * @param req
     * @return
     */
    PageResultDto<DayAppReportRsp> selectAppDataV1(ReqAppStatistics req);


    List<DayReportRsp> selectDayReportData(ReqReportByPage reqReportByPage);

    List<DayReportRsp> selectDayReportDataV1(ReqAppStatistics req);

    List<DayReportRsp> selectReportDataV1(ReqAppStatistics req);

    PageResultDto<DayReportRspList> selectDayReportListNew(ReqReportByPage req);

}
