package cn.com.duiba.tuia.pangea.center.api.rsp;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author yuantong
 * @version 1.0
 * @since 2019-10-23 16:22
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class DayReportRspList implements Serializable {

    private static final long serialVersionUID = 3809868989939784143L;

    private Integer id;
    private Boolean showButton;

    //测试组组装
    private List<Long> activityId;
    private List<Integer> activityType;
    private List<Integer> activityStatus;
    private List<Integer> activityPrcent;
    private List<Long> activitySource;

    private List<Long> actRequestPv;
    private List<Long> actRequestUv;
    private List<Long> actJoinUv;
    private List<Long> actJoinPv;
    private List<Float> rptParticipateCount;
    private List<Long> advertRequestPv;
    private List<Long> advertRequestCount;
    private List<Long> advertShowCount;
    private List<Long> advertClickCount;
    private List<Float> ctr;
    private List<Float> actPerUvClickCount;
    private List<Float> actPerUvLaunchCount;
    private List<Float> actPerUvClickLaunchCount;
    private List<Float> actPerUvConsume;
    private List<Long> formFeeClick;
    private List<Long> formLandPv;
    private List<Float> formAdvertCvr;
    private List<Long> formLandInnerPv;
    private List<Float> cvr;
    private List<Float> actParticipateRate;
    private List<Float> requestSuccessRate;
    private List<Long> adConsume;
    private List<Float> advertSuccessRate;

    @SuppressWarnings("squid:S3776")
    public static DayReportRspList setList(DayReportRsp reportRsp) {
        DayReportRspList dto = new DayReportRspList();
        if (CollectionUtils.isEmpty(reportRsp.getActRequestPvs())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getActRequestPv());
            dto.setActRequestPv(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getActRequestUvs())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getActRequestUv());
            dto.setActRequestUv(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getActJoinUvs())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getActJoinUv());
            dto.setActJoinUv(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getActJoinPvs())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getActJoinPv());
            dto.setActJoinPv(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getRptParticipateCounts())) {
            List<Float> floats = new ArrayList<>();
            floats.add(reportRsp.getRptParticipateCount());
            dto.setRptParticipateCount(floats);
        }

        if (CollectionUtils.isEmpty(reportRsp.getAdvertRequestPvs())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getAdvertRequestPv());
            dto.setAdvertRequestPv(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getAdvertRequestCounts())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getAdvertRequestCount());
            dto.setAdvertRequestCount(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getAdvertShowCounts())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getAdvertShowCount());
            dto.setAdvertShowCount(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getAdvertClickCounts())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getAdvertClickCount());
            dto.setAdvertClickCount(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getCtrs())) {
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getCtr());
            dto.setCtr(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getActPerUvClickCounts())) {
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getActPerUvClickCount());
            dto.setActPerUvClickCount(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getActPerUvLaunchCounts())) {
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getActPerUvLaunchCount());
            dto.setActPerUvLaunchCount(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getActPerUvClickLaunchCounts())) {
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getActPerUvClickLaunchCount());
            dto.setActPerUvClickLaunchCount(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getActPerUvConsumes())) {
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getActPerUvConsume());
            dto.setActPerUvConsume(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getFormFeeClicks())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getFormFeeClick());
            dto.setFormFeeClick(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getFormLandPvs())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getFormLandPv());
            dto.setFormLandPv(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getFormAdvertCvrs())) {
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getFormAdvertCvr());
            dto.setFormAdvertCvr(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getFormLandInnerPvs())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getFormLandInnerPv());
            dto.setFormLandInnerPv(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getCvrs())) {
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getCvr());
            dto.setCvr(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getActivityIds())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getActivityId());
            dto.setActivityId(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getActivityStatuss())) {
            List<Integer> longs = new ArrayList<>();
            longs.add(reportRsp.getActivityStatus());
            dto.setActivityStatus(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getActivityTypes())) {
            List<Integer> longs = new ArrayList<>();
            longs.add(reportRsp.getActivityType());
            dto.setActivityType(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getActivityPrcents())) {
            List<Integer> longs = new ArrayList<>();
            longs.add(reportRsp.getActivityPrcent());
            dto.setActivityPrcent(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getActParticipateRates())) {
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getActParticipateRate());
            dto.setActParticipateRate(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getRequestSuccessRates())) {
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getRequestSuccessRate());
            dto.setRequestSuccessRate(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getAdConsumes())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getAdConsume());
            dto.setAdConsume(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getActivitySources())) {
            List<Long> longs = new ArrayList<>();
            longs.add(reportRsp.getActivitySource());
            dto.setActivitySource(longs);
        }

        if (CollectionUtils.isEmpty(reportRsp.getAdvertSuccessRates())) {
            List<Float> longs = new ArrayList<>();
            longs.add(reportRsp.getAdvertSuccessRate());
            dto.setAdvertSuccessRate(longs);
        }
        return dto;
    }
}
