package cn.com.duiba.tuia.pangea.center.api.req.resource;

import cn.com.duiba.tuia.pangea.center.api.dto.resource.TestResourceFlowDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 单个测试组配置修改
 * @author miaohongshuai
*/
@Data
public class ResourceFlowTestSingleUpdateReq {

    @ApiModelProperty(value = "测试计划ID")
    private Long planId;
    @ApiModelProperty(value = "活动ID")
    private Long activityId;
    @ApiModelProperty(value = "广告位ID")
    private Long slotId;

    @ApiModelProperty(value = "测试类型，默认0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层", required = true)
    private Integer testType;
    @ApiModelProperty(value = "修改的测试总占比")
    private Integer testVisitorRatio;
    @ApiModelProperty(value = "测试组配置")
    private List<TestResourceFlowDTO> testGroupList;
}
