package cn.com.duiba.tuia.pangea.center.api.dto.resource;

import cn.com.duiba.tuia.pangea.center.api.req.resource.ProbReq;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 测试计划-广告位测试活动 资源（浮标）测试组
 * @author miaohongshuai
*/
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString
public class TestResourceFlowDTO implements Serializable {
    private static final long serialVersionUID = -6083886715789754497L;
    /**
     * 表映射主键
     */
    private Long resourceFlowId;
    /**
     * 测试计划id
     */
    private Long planId;
    /**
     * 广告位id
     */
    private Long slotId;
    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 测试资源id，浮标/下拉/返回拦截/响应式插件/弹层的ID
     */
    private Long resourceId;
    /**
     * 分流比例，整数
     */
    private Integer flowPercent;
    /**
     * 计划开始时间
     */
    private Date startTime;
    /**
     * 计划结束时间
     */
    private Date endTime;
    /**
     * 设置第几次出测试资源
     */
    private Integer buoyCount;
    /**
     * 0非返回拦截 1一次返回拦截 2二次返回拦截 3三次返回拦截
     */
    private Integer backType;
    /**
     * 计划状态 1未开始 2测试中 30到期停止 31 熔断 32运营操作下线
     */
    private Integer testStatus;
    /**
     * 组序号
     */
    private Integer groupTag;
    /**
     * 操作人id
     */
    private Long adminId;
    /**
     * 配置类型，0：大盘默认，1：定制
     */
    private Integer configType;
    /**
     * 具体配置
     */
    private ProbReq config;

    /**
     * 测试类型，0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层
     */
    private Integer testType;

    /**
     * 更新状态，0：未更新，1：更新过
     */
    private Integer updateStatus;

    private Date gmtCreate;
    private Date gmtModified;
}
