/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.simple;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.ds.simple.SimpleDataSource;
import cn.hutool.setting.Setting;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class SimpleDSFactory
extends DSFactory {
    public static final String DS_NAME = "Hutool-Simple-DataSource";
    private Map<String, SimpleDataSource> dsMap = new ConcurrentHashMap<String, SimpleDataSource>();

    public SimpleDSFactory() {
        this(null);
    }

    public SimpleDSFactory(Setting setting) {
        super(DS_NAME, SimpleDataSource.class, setting);
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        SimpleDataSource existedDataSource = this.dsMap.get(group);
        if (existedDataSource != null) {
            return existedDataSource;
        }
        SimpleDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        SimpleDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            IoUtil.close(ds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<SimpleDataSource> values = this.dsMap.values();
            for (SimpleDataSource ds : values) {
                IoUtil.close(ds);
            }
            this.dsMap.clear();
        }
    }

    private SimpleDataSource createDataSource(String group) {
        SimpleDataSource ds = new SimpleDataSource(this.setting, group);
        return ds;
    }
}

