/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.Operation;
import springfox.documentation.spi.service.contexts.ApiSelector;
import springfox.documentation.spi.service.contexts.PathContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.readers.operation.OperationReader;
import springfox.documentation.spring.web.scanners.ApiDescriptionLookup;

@Component
public class ApiDescriptionReader {
    private final OperationReader operationReader;
    private final DocumentationPluginsManager pluginsManager;
    private final ApiDescriptionLookup lookup;

    @Autowired
    public ApiDescriptionReader(@Qualifier(value="cachedOperations") OperationReader operationReader, DocumentationPluginsManager pluginsManager, ApiDescriptionLookup lookup) {
        this.operationReader = operationReader;
        this.pluginsManager = pluginsManager;
        this.lookup = lookup;
    }

    public List<ApiDescription> read(RequestMappingContext outerContext) {
        PatternsRequestCondition patternsCondition = outerContext.getPatternsCondition();
        ApiSelector selector = outerContext.getDocumentationContext().getApiSelector();
        ArrayList apiDescriptionList = Lists.newArrayList();
        for (String path : this.matchingPaths(selector, patternsCondition)) {
            String methodName = outerContext.getName();
            RequestMappingContext operationContext = outerContext.copyPatternUsing(path);
            List<Operation> operations = this.operationReader.read(operationContext);
            if (operations.size() <= 0) continue;
            operationContext.apiDescriptionBuilder().operations(operations).pathDecorator(this.pluginsManager.decorator(new PathContext(outerContext, FluentIterable.from(operations).first()))).path(path).description(methodName).hidden(false);
            ApiDescription apiDescription = operationContext.apiDescriptionBuilder().build();
            this.lookup.add(outerContext.key(), apiDescription);
            apiDescriptionList.add(apiDescription);
        }
        return apiDescriptionList;
    }

    private List<String> matchingPaths(ApiSelector selector, PatternsRequestCondition patternsCondition) {
        return Ordering.natural().sortedCopy((Iterable)FluentIterable.from((Iterable)patternsCondition.getPatterns()).filter(selector.getPathSelector()));
    }
}

