/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.spring.velocity;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class VelocityClasspathResourceLoader
extends ClasspathResourceLoader {
    private List<String> paths = new ArrayList<String>();

    public void init(ExtendedProperties configuration) {
        super.init(configuration);
        for (Object pathObj : configuration.getVector("path")) {
            String path = (String)pathObj;
            if (path == null) continue;
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            this.paths.add(path);
        }
    }

    public InputStream getResourceStream(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new ResourceNotFoundException("No template name provided");
        }
        String name1 = name;
        if (!name1.startsWith("/")) {
            name1 = "/" + name1;
        }
        InputStream is = null;
        for (String path : this.paths) {
            try {
                is = super.getResourceStream(path + name1);
            }
            catch (ResourceNotFoundException e) {
                this.log.warn((Object)("try to find vm : " + path + name1 + ",but not found."), (Throwable)e);
            }
        }
        if (is == null) {
            String msg = "ClasspathResourceLoader Error: cannot find resource " + name1;
            throw new ResourceNotFoundException(msg);
        }
        return is;
    }
}

