/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

public class SwitchUtils {
    public static boolean switchIsOpen(Integer switches, Integer binarySwitchLocation) {
        if (switches == null || binarySwitchLocation == null) {
            return false;
        }
        SwitchUtils.validateBinarySwitchLocationInteger(binarySwitchLocation);
        int v = 1 << binarySwitchLocation;
        int ret = switches & v;
        return ret != 0;
    }

    public static boolean switchIsOpen(Long switches, Integer binarySwitchLocation) {
        if (switches == null || binarySwitchLocation == null) {
            return false;
        }
        SwitchUtils.validateBinarySwitchLocationLong(binarySwitchLocation);
        long v = 1L << binarySwitchLocation;
        long ret = switches & v;
        return ret != 0L;
    }

    public static Integer openSwitch(Integer switches, Integer binarySwitchLocation) {
        if (switches == null) {
            switches = 0;
        }
        if (binarySwitchLocation == null) {
            return switches;
        }
        SwitchUtils.validateBinarySwitchLocationInteger(binarySwitchLocation);
        int v = 1 << binarySwitchLocation;
        return switches | v;
    }

    public static Long openSwitch(Long switches, Integer binarySwitchLocation) {
        if (switches == null) {
            switches = 0L;
        }
        if (binarySwitchLocation == null) {
            return switches;
        }
        SwitchUtils.validateBinarySwitchLocationLong(binarySwitchLocation);
        long v = 1L << binarySwitchLocation;
        return switches | v;
    }

    public static Integer closeSwitch(Integer switches, Integer binarySwitchLocation) {
        if (switches == null) {
            switches = 0;
        }
        if (binarySwitchLocation == null) {
            return switches;
        }
        SwitchUtils.validateBinarySwitchLocationInteger(binarySwitchLocation);
        int v = 1 << binarySwitchLocation;
        return switches & ~v;
    }

    public static Long closeSwitch(Long switches, Integer binarySwitchLocation) {
        if (switches == null) {
            switches = 0L;
        }
        if (binarySwitchLocation == null) {
            return switches;
        }
        SwitchUtils.validateBinarySwitchLocationLong(binarySwitchLocation);
        long v = 1L << binarySwitchLocation;
        return switches & (v ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static void validateBinarySwitchLocationLong(Integer binarySwitchLocation) {
        if (binarySwitchLocation < 0 || binarySwitchLocation > 63) {
            throw new IllegalArgumentException("arg[binarySwitchLocation] must between 0 and 63");
        }
    }

    private static void validateBinarySwitchLocationInteger(Integer binarySwitchLocation) {
        if (binarySwitchLocation < 0 || binarySwitchLocation > 31) {
            throw new IllegalArgumentException("arg[binarySwitchLocation] must between 0 and 31");
        }
    }
}

