package cn.com.duiba.tuia.pangea.center.api.constant;

/**
 * @author yuantong
 * @version 1.0
 * @since 2019-09-16 13:19
 */
public final class PgRedisKeyConstant {

    public static final String KEY_PREFIX = "PG_";

    public static final String KEY_PREFIX_PLAN = "PG_PLAN_";

    /**
     * A/B test 测试计划key
     */
    public static final String A_B_TEST_KEY = "KN19_";


    /**
     * 广告位 + 活动维度
     * @param activityId
     * @param slotId
     * @return
     */
    public static String getABTestActivitySlotInfoKey(final Long activityId, final Long slotId,
            final String curDate) {
        return KEY_PREFIX + A_B_TEST_KEY + slotId + SplitConstant.SPLIT_UNDERLINE + activityId +
                SplitConstant.SPLIT_UNDERLINE + curDate;
    }

    /**
     * 广告位维度
     * @param slotId
     * @return
     */
    public static String getABTestSlotKey(final Long slotId, final String curDate) {
        return KEY_PREFIX + A_B_TEST_KEY + SplitConstant.SPLIT_HYPHEN + slotId +
                SplitConstant.SPLIT_HYPHEN + curDate;
    }

}
