package cn.com.duiba.tuia.pangea.center.api.dto;

import lombok.Data;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;


/**
 * 此类描述的是：分页查询共用返回结果.
 */
@Data
public class PageResultDto<T extends Serializable> implements Serializable {

    private static final long serialVersionUID = 7622601582262632184L;

    private long totalCount;
    private int totalPage;
    private List<T> list;
    private Object sum;

    public PageResultDto() {
        super();
    }

    /**
     * Creates a new instance of PageResultDto.
     * @param totalCount 总记录数
     * @param list       数据列表
     * @param pageSize   每页记录数
     */
    public PageResultDto(long totalCount, List<T> list, int pageSize) {
        super();
        this.totalCount = totalCount;
        this.list = list;
        this.totalPage = setToalPage(pageSize);
    }

    public PageResultDto(long totalCount, List<T> list, Object sum, int pageSize) {
        super();
        this.totalCount = totalCount;
        this.list = list;
        this.sum = sum;
        this.totalPage = setToalPage(pageSize);
    }

    /**
     * 设置总页数.
     * @param pageSize 每页记录数
     * @return the int
     */
    private int setToalPage(int pageSize) {
        if (totalCount < 0) {
            return 0;
        }
        return (int) ((totalCount % pageSize == 0) ? totalCount / pageSize
                : totalCount / pageSize + 1);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
