package cn.com.duiba.tuia.pangea.center.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 测试类型，0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层
 * @author miaohongshuai
*/
public enum TestTypeEnum {
    ACTIVITY_TEST(0, "活动ABTest"),
    BUOY_TEST(1, "浮标ABTest"),
    PULL_TEST(2, "下拉ABTest"),
    BACK_TEST(3, "返回拦截ABTest"),
    RESPONSIVE_PLUGIN_TEST(11, "响应式插件ABTest"),
    LAYER_TEST(21, "弹层ABTest");

    @Getter
    private Integer testType;
    @Getter
    private String desc;

    TestTypeEnum(Integer testType, String desc) {
        this.testType = testType;
        this.desc = desc;
    }

    private static Map<Integer, TestTypeEnum> testTypeEnumMap;
    static {
        testTypeEnumMap = new HashMap<>(8);
        TestTypeEnum[] testTypeEnums = TestTypeEnum.values();
        for (TestTypeEnum testTypeEnum : testTypeEnums) {
            testTypeEnumMap.put(testTypeEnum.getTestType(), testTypeEnum);
        }
    }

    public static TestTypeEnum getEnumByTestType(Integer testType) {
        return testTypeEnumMap.get(testType);
    }
}
