package cn.com.duiba.tuia.pangea.center.api.req.resource;

import cn.com.duiba.tuia.pangea.center.api.dto.BaseQueryDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * 广告位活动的资源测试组列表查询
 * @author miaohongshuai
*/
@Data
@ToString
@EqualsAndHashCode(callSuper=false)
public class ResourceFlowTestListReq extends BaseQueryDto implements Serializable {

    private static final long serialVersionUID = -4234822794062209153L;
    /**
     * 搜索的媒体ID
     */
    private List<Long> searchAppIds;
    /**
     * 搜索的媒体名称
     */
//    private List<String> searchAppNames;
    /**
     * 搜索的广告位ID
     */
    private List<Long> searchSlotIds;
    /**
     * 搜索的广告位名称
     */
//    private List<String> searchSlotNames;
    /**
     * 搜索的活动ID
     */
    private List<Long> searchActivityIds;
    /**
     * 测试计划ID
     */
    private Long planId;
    /**
     * 分流活动ID列表
     */
    private List<Long> activityIds;
    /**
     * 分流广告位ID列表
     */
//    private List<Long> slotIds;
    /**
     * 测试类型，默认0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层
     */
    private Integer testType;

    /**
     * 测试范围是否是全部有回流数据活动，1：是，0：否，使用输入的活动列表
     */
    private Integer testActivityAll;

}
