package cn.com.duiba.tuia.pangea.center.api.rsp.resource;

import lombok.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author yuantong
 * @version 1.0
 * @since 2019-10-23 16:22
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class DayResourceReportRspList implements Serializable {

    private static final long serialVersionUID = 3809868989939784143L;

    private Integer id;
    /** 测试计划id */
    private Long planId;
    /** 测试组序号 */
    private List<Integer> groupTag = new ArrayList<>();
    /** 是否展示操作按钮 */
    private Boolean showButton;

    /** 资源id，浮标/下拉、响应式插件、弹层id，返回拦截次数（1/2/3) */
    private List<Long> resourceId = new ArrayList<>();
    /** 测试组的占比 */
    private List<Integer> resourcePercent = new ArrayList<>();
    /** 测试组的资源次序 */
    private List<Integer> resourceCount = new ArrayList<>();
    /** 测试组测试状态， 1未开始 2测试中 30到期停止 31 熔断 32运营操作下线 */
    private List<Integer> resourceStatus = new ArrayList<>();

    /** 浮标/下拉曝光PV */
    private List<Long> buoyExposurePv;
    /** 浮标/下拉曝光UV */
    private List<Long> buoyExposureUv;
    /** 浮标/下拉点击PV */
    private List<Long> buoyClickPv;
    /** 浮标/下拉点击UV */
    private List<Long> buoyClickUv;
    /** 浮标/下拉ctr（pv) */
    private List<Float> buoyCtrPv;
    /** 浮标/下拉ctr（uv) */
    private List<Float> buoyCtrUv;

    /** 拦截访问PV */
    private List<Long> interceptRequestPv;
    /** 拦截访问UV */
    private List<Long> interceptRequestUv;

    /** 插件曝光PV */
    private List<Long> pluginExposurePv;
    /** 插件曝光UV */
    private List<Long> pluginExposureUv;
    /** 插件点击PV */
    private List<Long> pluginClickPv;
    /** 插件点击UV */
    private List<Long> pluginClickUv;
    /** 插件ctr（pv) */
    private List<Float> pluginCtrPv;
    /** 插件ctr（uv) */
    private List<Float> pluginCtrUv;

    /** 弹层曝光PV */
    private List<Long> layerExposurePv;
    /** 弹层曝光UV */
    private List<Long> layerExposureUv;
    /** 弹层点击PV */
    private List<Long> layerClickPv;
    /** 弹层点击UV */
    private List<Long> layerClickUv;
    /** 弹层ctr（pv) */
    private List<Float> layerCtrPv;
    /** 弹层ctr（uv) */
    private List<Float> layerCtrUv;

    /** 券请求PV */
    private List<Long> advertRequestPv = new ArrayList<>();
    /** 券请求UV */
    private List<Long> advertRequestUv = new ArrayList<>();
    /** 发券量PV */
    private List<Long> advertRequestCountPv = new ArrayList<>();
    /** 发券量UV */
    private List<Long> advertRequestCountUv = new ArrayList<>();
    /** 券曝光UV */
    private List<Long> advertShowCountPv = new ArrayList<>();
    /** 券曝光UV */
    private List<Long> advertShowCountUv = new ArrayList<>();
    /** 券点击UV */
    private List<Long> advertClickCountPv = new ArrayList<>();
    /** 券点击UV */
    private List<Long> advertClickCountUv = new ArrayList<>();

    /** 每UV参与 */
    private List<Float> perUvClickCount = new ArrayList<>();
    /** 每UV发券 */
    private List<Float> perUvLaunchCount = new ArrayList<>();
    /** 每UV券点击 */
    private List<Float> perUvClickLaunchCount = new ArrayList<>();
    /** 每UV消耗 */
    private List<Float> perUvConsume = new ArrayList<>();

    private List<Float> rptParticipateCount = new ArrayList<>();
    private List<Long> formFeeClick = new ArrayList<>();
    private List<Long> formLandPv = new ArrayList<>();
    private List<Float> formAdvertCvr = new ArrayList<>();
    private List<Long> formLandInnerPv = new ArrayList<>();
    private List<Float> ctr = new ArrayList<>();
    private List<Float> cvr = new ArrayList<>();
    private List<Float> requestSuccessRate = new ArrayList<>();
    private List<Long> adConsume = new ArrayList<>();
    private List<Float> advertSuccessRate = new ArrayList<>();

    public void buoyInitialize() {
        buoyExposurePv = new ArrayList<>();
        buoyExposureUv = new ArrayList<>();
        buoyClickPv = new ArrayList<>();
        buoyClickUv = new ArrayList<>();
        buoyCtrPv = new ArrayList<>();
        buoyCtrUv = new ArrayList<>();
    }

    public void interceptInitialize() {
        interceptRequestPv = new ArrayList<>();
        interceptRequestUv = new ArrayList<>();
    }

    public void pluginInitialize() {
        pluginExposurePv = new ArrayList<>();
        pluginExposureUv = new ArrayList<>();
        pluginClickPv = new ArrayList<>();
        pluginClickUv = new ArrayList<>();
        pluginCtrPv = new ArrayList<>();
        pluginCtrUv = new ArrayList<>();
    }

    public void layerInitialize() {
        layerExposurePv = new ArrayList<>();
        layerExposureUv = new ArrayList<>();
        layerClickPv = new ArrayList<>();
        layerClickUv = new ArrayList<>();
        layerCtrPv = new ArrayList<>();
        layerCtrUv = new ArrayList<>();
    }
}
