package cn.com.duiba.tuia.purchase.web.api.model.resp;

import lombok.Getter;
import lombok.Setter;

/**
 * @author zhongda & ikongyi
 */
@Getter
@Setter
public class JdUnionCpsTaskPromoLinkGetResponse {
    /**
     * 生成的推广目标链接，以短链接形式，有效期60天
     * e.g. https://u.jd.com/XXXXX
     */
    private String shortURL;
    /**
     * 生成推广目标的长链，长期有效
     * e.g. https://union-click.jd.com/jdc?e=XXXXXX p=XXXXXXXXXXX
     */
    private String clickURL;
    /**
     * 京口令（匹配到红包活动有效配置才会返回京口令），需要权限申请
     * e.g. 复制整段话 http://JhT7V5wlKygHDK京口令内容#J6UFE5iMn***
     */
    private String jCommand;
    /**
     * 短口令，需要权限申请
     */
    private String jShortCommand;
    /**
     * 微信小程序ShortLink（需向cps-qxsq@jd.com申请权限）
     * e.g. #小程序://京小街/****
     */
    private String weChatShortLink;
}
